/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.NeedsLocalLogs;
import org.openqa.selenium.logging.profiler.HttpProfilerLogEntry;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class HttpCommandExecutor
implements CommandExecutor,
NeedsLocalLogs {
    private final URL remoteServer;
    public final HttpClient client;
    protected final HttpClient.Factory httpClientFactory;
    protected final Map<String, CommandInfo> additionalCommands;
    protected CommandCodec<HttpRequest> commandCodec;
    protected ResponseCodec<HttpResponse> responseCodec;
    private LocalLogs logs = LocalLogs.getNullLogger();

    public static HttpClient.Factory getDefaultClientFactory() {
        return DefaultClientFactoryHolder.defaultClientFactory;
    }

    public HttpCommandExecutor(URL addressOfRemoteServer) {
        this(Collections.emptyMap(), (URL)Require.nonNull((String)"Server URL", (Object)addressOfRemoteServer));
    }

    public HttpCommandExecutor(ClientConfig config) {
        this(Collections.emptyMap(), (ClientConfig)Require.nonNull((String)"HTTP client configuration", (Object)config), HttpCommandExecutor.getDefaultClientFactory());
    }

    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer) {
        this((Map<String, CommandInfo>)((Map)Require.nonNull((String)"Additional commands", additionalCommands)), (URL)Require.nonNull((String)"Server URL", (Object)addressOfRemoteServer), HttpCommandExecutor.getDefaultClientFactory());
    }

    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer, ClientConfig config) {
        this(additionalCommands, config.baseUrl((URL)Require.nonNull((String)"Server URL", (Object)addressOfRemoteServer)), HttpCommandExecutor.getDefaultClientFactory());
    }

    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory) {
        this(additionalCommands, ClientConfig.defaultConfig().baseUrl((URL)Require.nonNull((String)"Server URL", (Object)addressOfRemoteServer)), httpClientFactory);
    }

    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, ClientConfig config, HttpClient.Factory httpClientFactory) {
        this.remoteServer = ((ClientConfig)Require.nonNull((String)"HTTP client configuration", (Object)config)).baseUrl();
        this.additionalCommands = new HashMap<String, CommandInfo>((Map)Require.nonNull((String)"Additional commands", additionalCommands));
        this.httpClientFactory = (HttpClient.Factory)Require.nonNull((String)"HTTP client factory", (Object)httpClientFactory);
        this.client = this.httpClientFactory.createClient(config);
    }

    public Map<String, CommandInfo> getAdditionalCommands() {
        return Collections.unmodifiableMap(this.additionalCommands);
    }

    protected void addAdditionalCommand(String commandName, CommandInfo info) {
        Require.nonNull((String)"Command name", (Object)commandName);
        Require.nonNull((String)"Command info", (Object)info);
        this.additionalCommands.put(commandName, info);
    }

    protected void defineCommand(String commandName, CommandInfo info) {
        Require.nonNull((String)"Command name", (Object)commandName);
        Require.nonNull((String)"Command info", (Object)info);
        this.commandCodec.defineCommand(commandName, info.getMethod(), info.getUrl());
    }

    public void setLocalLogs(LocalLogs logs) {
        this.logs = logs;
    }

    private void log(String logType, LogEntry entry) {
        this.logs.addEntry(logType, entry);
    }

    public URL getAddressOfRemoteServer() {
        return this.remoteServer;
    }

    @Override
    public Response execute(Command command) throws IOException {
        if (command.getSessionId() == null) {
            if ("quit".equals(command.getName())) {
                return new Response();
            }
            if (!"newSession".equals(command.getName())) {
                throw new NoSuchSessionException("Session ID is null. Using WebDriver after calling quit()?");
            }
        }
        if ("newSession".equals(command.getName())) {
            if (this.commandCodec != null) {
                throw new SessionNotCreatedException("Session already exists");
            }
            ProtocolHandshake handshake = new ProtocolHandshake();
            this.log("profiler", (LogEntry)new HttpProfilerLogEntry(command.getName(), true));
            ProtocolHandshake.Result result = handshake.createSession((HttpHandler)this.client, command);
            Dialect dialect = result.getDialect();
            this.commandCodec = dialect.getCommandCodec();
            for (Map.Entry<String, CommandInfo> entry : this.additionalCommands.entrySet()) {
                this.defineCommand(entry.getKey(), entry.getValue());
            }
            this.responseCodec = dialect.getResponseCodec();
            this.log("profiler", (LogEntry)new HttpProfilerLogEntry(command.getName(), false));
            return result.createResponse();
        }
        if (this.commandCodec == null || this.responseCodec == null) {
            throw new WebDriverException("No command or response codec has been defined. Unable to proceed");
        }
        HttpRequest httpRequest = this.commandCodec.encode(command);
        if (httpRequest.getHeader("Content-Type") == null) {
            httpRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        }
        try {
            this.log("profiler", (LogEntry)new HttpProfilerLogEntry(command.getName(), true));
            HttpResponse httpResponse = this.client.execute(httpRequest);
            this.log("profiler", (LogEntry)new HttpProfilerLogEntry(command.getName(), false));
            Response response = this.responseCodec.decode(httpResponse);
            if (response.getSessionId() == null) {
                if (httpResponse.getTargetHost() != null) {
                    response.setSessionId(HttpSessionId.getSessionId(httpResponse.getTargetHost()).orElse(null));
                } else {
                    response.setSessionId(command.getSessionId().toString());
                }
            }
            if ("quit".equals(command.getName())) {
                this.client.close();
                this.httpClientFactory.cleanupIdleClients();
            }
            return response;
        }
        catch (UnsupportedCommandException e) {
            if (e.getMessage() == null || "".equals(e.getMessage())) {
                throw new UnsupportedOperationException("No information from server. Command name was: " + command.getName(), e.getCause());
            }
            throw e;
        }
    }

    private static class DefaultClientFactoryHolder {
        static HttpClient.Factory defaultClientFactory = HttpClient.Factory.createDefault();

        private DefaultClientFactoryHolder() {
        }
    }
}

