/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.io.Serializable;
import java.util.Comparator;

public class SemanticVersionComparator
implements Comparator<String>,
Serializable {
    @Override
    public int compare(String v1, String v2) {
        if (v1.isEmpty() && v2.isEmpty()) {
            return 0;
        }
        if (v1.isEmpty()) {
            return 1;
        }
        if (v2.isEmpty()) {
            return -1;
        }
        String[] parts1 = v1.split("\\.");
        String[] parts2 = v2.split("\\.");
        int maxLength = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < maxLength; ++i) {
            String part1 = i < parts1.length ? parts1[i] : "0";
            String part2 = i < parts2.length ? parts2[i] : part1;
            boolean isPart1Numeric = this.isNumber(part1);
            boolean isPart2Numeric = this.isNumber(part2);
            if (isPart1Numeric && isPart2Numeric) {
                int num2;
                int num1 = Integer.parseInt(part1);
                if (num1 == (num2 = Integer.parseInt(part2))) continue;
                return Integer.compare(num1, num2);
            }
            if (!isPart1Numeric && !isPart2Numeric) {
                int result = part1.compareToIgnoreCase(part2);
                if (result == 0) continue;
                return result;
            }
            return isPart1Numeric ? 1 : -1;
        }
        return 0;
    }

    private boolean isNumber(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }
}

