/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.BiDiException;
import org.openqa.selenium.bidi.Connection;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.firefox.AddHasContext;
import org.openqa.selenium.firefox.AddHasExtensions;
import org.openqa.selenium.firefox.AddHasFullPageScreenshot;
import org.openqa.selenium.firefox.FirefoxCommandContext;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.firefox.HasContext;
import org.openqa.selenium.firefox.HasExtensions;
import org.openqa.selenium.firefox.HasFullPageScreenshot;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebDriverBuilder;
import org.openqa.selenium.remote.html5.RemoteWebStorage;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverFinder;
import org.openqa.selenium.remote.service.DriverService;

public class FirefoxDriver
extends RemoteWebDriver
implements WebStorage,
HasExtensions,
HasFullPageScreenshot,
HasContext,
HasBiDi {
    private static final Logger LOG = Logger.getLogger(FirefoxDriver.class.getName());
    private final Capabilities capabilities;
    private final RemoteWebStorage webStorage = new RemoteWebStorage(this.getExecuteMethod());
    private final HasExtensions extensions = new AddHasExtensions().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    private final HasFullPageScreenshot fullPageScreenshot = new AddHasFullPageScreenshot().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    private final HasContext context = new AddHasContext().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    private final Optional<URI> biDiUri;
    private final Optional<BiDi> biDi;

    public FirefoxDriver() {
        this(new FirefoxOptions());
    }

    public FirefoxDriver(FirefoxOptions options) {
        this(GeckoDriverService.createDefaultService(), options);
    }

    public FirefoxDriver(FirefoxDriverService service) {
        this(service, new FirefoxOptions());
    }

    public FirefoxDriver(FirefoxDriverService service, FirefoxOptions options) {
        this(service, options, ClientConfig.defaultConfig());
    }

    public FirefoxDriver(FirefoxDriverService service, FirefoxOptions options, ClientConfig clientConfig) {
        this(FirefoxDriver.generateExecutor(service, options, clientConfig), options);
    }

    private static FirefoxDriverCommandExecutor generateExecutor(FirefoxDriverService service, FirefoxOptions options, ClientConfig clientConfig) {
        Require.nonNull("Driver service", service);
        Require.nonNull("Driver options", options);
        Require.nonNull("Driver clientConfig", clientConfig);
        DriverFinder finder = new DriverFinder(service, options);
        service.setExecutable(finder.getDriverPath());
        if (finder.hasBrowserPath()) {
            options.setBinary(finder.getBrowserPath());
            options.setCapability("browserVersion", (Object)null);
        }
        return new FirefoxDriverCommandExecutor(service, clientConfig);
    }

    private FirefoxDriver(FirefoxDriverCommandExecutor executor, FirefoxOptions options) {
        this(executor, options, ClientConfig.defaultConfig());
    }

    private FirefoxDriver(FirefoxDriverCommandExecutor executor, FirefoxOptions options, ClientConfig clientConfig) {
        super(executor, FirefoxDriver.checkCapabilitiesAndProxy(options));
        Capabilities capabilities = super.getCapabilities();
        Optional<String> webSocketUrl = Optional.ofNullable((String)capabilities.getCapability("webSocketUrl"));
        this.biDiUri = webSocketUrl.map(uri -> {
            try {
                return new URI((String)uri);
            }
            catch (URISyntaxException e) {
                LOG.warning(e.getMessage());
                return null;
            }
        });
        this.biDi = this.createBiDi(this.biDiUri);
        this.capabilities = new ImmutableCapabilities(capabilities);
    }

    @Beta
    public static RemoteWebDriverBuilder builder() {
        return RemoteWebDriver.builder().oneOf(new FirefoxOptions(), new Capabilities[0]);
    }

    private static Capabilities checkCapabilitiesAndProxy(Capabilities capabilities) {
        if (capabilities == null) {
            return new ImmutableCapabilities();
        }
        MutableCapabilities caps = new MutableCapabilities(capabilities);
        Proxy proxy = Proxy.extractFrom(capabilities);
        if (proxy != null) {
            caps.setCapability("proxy", proxy);
        }
        return caps;
    }

    @Override
    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    @Override
    @Deprecated
    public LocalStorage getLocalStorage() {
        return this.webStorage.getLocalStorage();
    }

    @Override
    @Deprecated
    public SessionStorage getSessionStorage() {
        return this.webStorage.getSessionStorage();
    }

    @Override
    public String installExtension(Path path) {
        Require.nonNull("Path", path);
        return this.extensions.installExtension(path);
    }

    @Override
    public String installExtension(Path path, Boolean temporary) {
        Require.nonNull("Path", path);
        Require.nonNull("Temporary", temporary);
        return this.extensions.installExtension(path, temporary);
    }

    @Override
    public void uninstallExtension(String extensionId) {
        Require.nonNull("Extension ID", extensionId);
        this.extensions.uninstallExtension(extensionId);
    }

    @Override
    public <X> X getFullPageScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        Require.nonNull("OutputType", outputType);
        return this.fullPageScreenshot.getFullPageScreenshotAs(outputType);
    }

    @Override
    public FirefoxCommandContext getContext() {
        return this.context.getContext();
    }

    @Override
    public void setContext(FirefoxCommandContext commandContext) {
        Require.nonNull("Firefox Command Context", commandContext);
        this.context.setContext(commandContext);
    }

    private Optional<BiDi> createBiDi(Optional<URI> biDiUri) {
        if (biDiUri.isEmpty()) {
            return Optional.empty();
        }
        URI wsUri = biDiUri.orElseThrow(() -> new BiDiException("Check if this browser version supports BiDi and if the 'webSocketUrl: true' capability is set."));
        HttpClient.Factory clientFactory = HttpClient.Factory.createDefault();
        ClientConfig wsConfig = ClientConfig.defaultConfig().baseUri(wsUri);
        HttpClient wsClient = clientFactory.createClient(wsConfig);
        Connection biDiConnection = new Connection(wsClient, wsUri.toString());
        return Optional.of(new BiDi(biDiConnection));
    }

    @Override
    public Optional<BiDi> maybeGetBiDi() {
        return this.biDi;
    }

    @Override
    public BiDi getBiDi() {
        if (this.biDiUri.isEmpty()) {
            throw new BiDiException("Check if this browser version supports BiDi and if the 'webSocketUrl: true' capability is set.");
        }
        return this.maybeGetBiDi().orElseThrow(() -> new BiDiException("Unable to initialize Bidi connection"));
    }

    @Override
    public void quit() {
        super.quit();
    }

    private static class FirefoxDriverCommandExecutor
    extends DriverCommandExecutor {
        public FirefoxDriverCommandExecutor(DriverService service) {
            this(service, ClientConfig.defaultConfig());
        }

        public FirefoxDriverCommandExecutor(DriverService service, ClientConfig clientConfig) {
            super(service, FirefoxDriverCommandExecutor.getExtraCommands(), clientConfig);
        }

        private static Map<String, CommandInfo> getExtraCommands() {
            return Stream.of(new AddHasContext().getAdditionalCommands(), new AddHasExtensions().getAdditionalCommands(), new AddHasFullPageScreenshot().getAdditionalCommands()).flatMap(m4 -> m4.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    public static final class SystemProperty {
        public static final String BROWSER_BINARY = "webdriver.firefox.bin";
        public static final String BROWSER_PROFILE = "webdriver.firefox.profile";
    }
}

