/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.bidi.browsingcontext.UserPromptType;
import org.openqa.selenium.json.JsonInput;

public class UserPromptOpened {
    private final String browsingContextId;
    private final UserPromptType type;
    private final String message;

    private UserPromptOpened(String browsingContextId, UserPromptType type, String message) {
        this.browsingContextId = browsingContextId;
        this.type = type;
        this.message = message;
    }

    public static UserPromptOpened fromJson(JsonInput input) {
        String browsingContextId = null;
        UserPromptType type = null;
        String message = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "context": {
                    browsingContextId = (String)input.read((Type)((Object)String.class));
                    continue block10;
                }
                case "type": {
                    String userPromptType = (String)input.read((Type)((Object)String.class));
                    type = UserPromptType.findByName(userPromptType);
                    continue block10;
                }
                case "message": {
                    message = (String)input.read((Type)((Object)String.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new UserPromptOpened(browsingContextId, type, message);
    }

    public String getBrowsingContextId() {
        return this.browsingContextId;
    }

    public UserPromptType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    private Map<String, Object> toJson() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.put("browsingContextId", this.getBrowsingContextId());
        toReturn.put("type", (Object)this.getType());
        toReturn.put("message", this.getMessage());
        return Collections.unmodifiableMap(toReturn);
    }
}

