/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.test;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.ThreadUtils;
import org.junit.jupiter.api.Assertions;

public abstract class TestUtils {
    public static void assertEqualContent(byte[] b0, File file) throws IOException {
        TestUtils.assertEqualContent(b0, file.toPath());
    }

    public static void assertEqualContent(byte[] b0, Path file) throws IOException {
        int numRead = 0;
        byte[] b1 = new byte[b0.length];
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            int count;
            for (count = 0; count < b0.length && numRead >= 0; count += numRead) {
                numRead = is.read(b1, count, b0.length);
            }
            Assertions.assertEquals((int)b0.length, (int)count, (String)"Different number of bytes: ");
            for (int i = 0; i < count; ++i) {
                Assertions.assertEquals((byte)b0[i], (byte)b1[i], (String)("byte " + i + " differs"));
            }
        }
    }

    public static void assertEqualContent(char[] c0, File file) throws IOException {
        TestUtils.assertEqualContent(c0, file.toPath());
    }

    public static void assertEqualContent(char[] c0, Path file) throws IOException {
        int numRead = 0;
        char[] c1 = new char[c0.length];
        try (BufferedReader ir = Files.newBufferedReader(file);){
            int count;
            for (count = 0; count < c0.length && numRead >= 0; count += numRead) {
                numRead = ((Reader)ir).read(c1, count, c0.length);
            }
            Assertions.assertEquals((int)c0.length, (int)count, (String)"Different number of chars: ");
            for (int i = 0; i < count; ++i) {
                Assertions.assertEquals((char)c0[i], (char)c1[i], (String)("char " + i + " differs"));
            }
        }
    }

    private static void assertEqualContent(File f0, File f1) throws IOException {
        try (InputStream is0 = Files.newInputStream(f0.toPath(), new OpenOption[0]);
             InputStream is1 = Files.newInputStream(f1.toPath(), new OpenOption[0]);){
            byte[] buf0 = new byte[1024];
            byte[] buf1 = new byte[1024];
            int n0 = 0;
            while (-1 != n0) {
                n0 = is0.read(buf0);
                int n1 = is1.read(buf1);
                Assertions.assertEquals((int)n0, (int)n1, (String)("The files " + f0 + " and " + f1 + " have differing number of bytes available (" + n0 + " vs " + n1 + ")"));
                Assertions.assertArrayEquals((byte[])buf0, (byte[])buf1, (String)("The files " + f0 + " and " + f1 + " have different content"));
            }
        }
    }

    public static void checkFile(File file, File referenceFile) throws Exception {
        Assertions.assertTrue((boolean)file.exists(), (String)"Check existence of output file");
        TestUtils.assertEqualContent(referenceFile, file);
    }

    public static void checkWrite(OutputStream output) {
        try {
            new PrintStream(output).write(0);
        }
        catch (Throwable t2) {
            Assertions.fail((String)("The copy() method closed the stream when it shouldn't have. " + t2.getMessage()));
        }
    }

    public static void checkWrite(Writer output) {
        try {
            new PrintWriter(output).write(97);
        }
        catch (Throwable t2) {
            Assertions.fail((String)("The copy() method closed the stream when it shouldn't have. " + t2.getMessage()));
        }
    }

    public static void createFile(File file, long size) throws IOException {
        if (!file.getParentFile().exists()) {
            throw new IOException("Cannot create file " + file + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, size);
        }
    }

    public static void createFile(Path file, long size) throws IOException {
        if (!Files.exists(file.getParent(), new LinkOption[0])) {
            throw new IOException("Cannot create file " + file + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            TestUtils.generateTestData(output, size);
        }
    }

    public static void createLineBasedFile(File file, String[] data) throws IOException {
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            throw new IOException("Cannot create file " + file + " as the parent directory does not exist");
        }
        try (PrintWriter output = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            for (String element : data) {
                output.println(element);
            }
        }
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            Assertions.assertTrue((boolean)file.delete(), (String)("Couldn't delete file: " + file));
        }
    }

    public static void generateTestData(File file, long size) throws IOException, FileNotFoundException {
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            TestUtils.generateTestData(output, size);
        }
    }

    public static byte[] generateTestData(long size) {
        byte[] byArray;
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        try {
            TestUtils.generateTestData(baout, size);
            byArray = baout.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baout.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new IllegalStateException("This should never happen: " + ioe.getMessage(), ioe);
            }
        }
        baout.close();
        return byArray;
    }

    public static void generateTestData(OutputStream out, long size) throws IOException {
        int i = 0;
        while ((long)i < size) {
            out.write((byte)(i % 127 + 1));
            ++i;
        }
    }

    public static File newFile(File testDirectory, String fileName) throws IOException {
        File destination = new File(testDirectory, fileName);
        if (destination.exists()) {
            FileUtils.forceDelete(destination);
        }
        return destination;
    }

    public static void sleep(long millis) throws InterruptedException {
        ThreadUtils.sleep((Duration)Duration.ofMillis(millis));
    }

    public static void sleepQuietly(long millis) {
        try {
            TestUtils.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private TestUtils() {
    }
}

