/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.io.TaggedIOException;
import org.apache.commons.io.output.BrokenOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ClosedOutputStream;
import org.apache.commons.io.output.TaggedOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TaggedOutputStreamTest {
    @Test
    public void testBrokenStream() {
        IOException exception = new IOException("test exception");
        TaggedOutputStream stream = new TaggedOutputStream(new BrokenOutputStream(exception));
        try {
            stream.write(120);
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)stream.isCauseOf(e));
            try {
                stream.throwIfCauseOf(e);
                Assertions.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assertions.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            stream.flush();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)stream.isCauseOf(e));
            try {
                stream.throwIfCauseOf(e);
                Assertions.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assertions.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            stream.close();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)stream.isCauseOf(e));
            try {
                stream.throwIfCauseOf(e);
                Assertions.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assertions.assertEquals((Object)exception, (Object)e2);
            }
        }
    }

    @Test
    public void testNormalStream() {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            try (TaggedOutputStream stream = new TaggedOutputStream(buffer);){
                ((OutputStream)stream).write(97);
                ((OutputStream)stream).write(new byte[]{98});
                ((OutputStream)stream).write(new byte[]{99}, 0, 1);
                ((OutputStream)stream).flush();
            }
            Assertions.assertEquals((int)3, (int)buffer.size());
            Assertions.assertEquals((int)97, (int)buffer.toByteArray()[0]);
            Assertions.assertEquals((int)98, (int)buffer.toByteArray()[1]);
            Assertions.assertEquals((int)99, (int)buffer.toByteArray()[2]);
        }
        catch (IOException e) {
            Assertions.fail((String)"Unexpected exception thrown");
        }
    }

    @Test
    public void testOtherException() throws Exception {
        IOException exception = new IOException("test exception");
        try (TaggedOutputStream stream = new TaggedOutputStream(ClosedOutputStream.INSTANCE);){
            Assertions.assertFalse((boolean)stream.isCauseOf(exception));
            Assertions.assertFalse((boolean)stream.isCauseOf(new TaggedIOException(exception, UUID.randomUUID())));
            try {
                stream.throwIfCauseOf(exception);
            }
            catch (IOException e) {
                Assertions.fail((String)"Unexpected exception thrown");
            }
            try {
                stream.throwIfCauseOf(new TaggedIOException(exception, UUID.randomUUID()));
            }
            catch (IOException e) {
                Assertions.fail((String)"Unexpected exception thrown");
            }
        }
    }
}

