/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.input.BrokenInputStream;
import org.apache.commons.io.input.ProxyInputStreamTest;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.io.test.ThrowOnCloseInputStream;
import org.apache.commons.io.test.ThrowOnCloseOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TeeInputStreamTest {
    private final String ASCII = StandardCharsets.US_ASCII.name();
    private InputStream tee;
    private ByteArrayOutputStream output;

    @BeforeEach
    public void setUp() throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream("abc".getBytes(this.ASCII));
        this.output = new ByteArrayOutputStream();
        this.tee = new TeeInputStream((InputStream)input, this.output);
    }

    @Test
    public void testCloseBranchIOException() throws Exception {
        ByteArrayInputStream goodIs = (ByteArrayInputStream)Mockito.mock(ByteArrayInputStream.class);
        ThrowOnCloseOutputStream badOs = new ThrowOnCloseOutputStream();
        TeeInputStream nonClosingTis = new TeeInputStream(goodIs, badOs, false);
        nonClosingTis.close();
        ((ByteArrayInputStream)Mockito.verify((Object)goodIs)).close();
        TeeInputStream closingTis = new TeeInputStream(goodIs, badOs, true);
        Assertions.assertThrows(IOException.class, closingTis::close);
        ((ByteArrayInputStream)Mockito.verify((Object)goodIs, (VerificationMode)Mockito.times((int)2))).close();
    }

    @Test
    public void testCloseHandleIOException() throws IOException {
        ProxyInputStreamTest.testCloseHandleIOException(new TeeInputStream(new BrokenInputStream((Throwable)new IOException()), new ByteArrayOutputStream(), false));
        ProxyInputStreamTest.testCloseHandleIOException(new TeeInputStream(new BrokenInputStream((Throwable)new IOException()), new ByteArrayOutputStream(), true));
    }

    @Test
    public void testCloseMainIOException() throws IOException {
        ThrowOnCloseInputStream badIs = new ThrowOnCloseInputStream();
        ByteArrayOutputStream goodOs = (ByteArrayOutputStream)Mockito.mock(ByteArrayOutputStream.class);
        TeeInputStream nonClosingTis = new TeeInputStream(badIs, goodOs, false);
        Assertions.assertThrows(IOException.class, nonClosingTis::close);
        ((ByteArrayOutputStream)Mockito.verify((Object)goodOs, (VerificationMode)Mockito.never())).close();
        TeeInputStream closingTis = new TeeInputStream(badIs, goodOs, true);
        Assertions.assertThrows(IOException.class, closingTis::close);
        ((ByteArrayOutputStream)Mockito.verify((Object)goodOs)).close();
    }

    @Test
    public void testMarkReset() throws Exception {
        Assertions.assertEquals((int)97, (int)this.tee.read());
        this.tee.mark(1);
        Assertions.assertEquals((int)98, (int)this.tee.read());
        this.tee.reset();
        Assertions.assertEquals((int)98, (int)this.tee.read());
        Assertions.assertEquals((int)99, (int)this.tee.read());
        Assertions.assertEquals((int)-1, (int)this.tee.read());
        Assertions.assertEquals((Object)"abbc", (Object)this.output.toString(this.ASCII));
    }

    @Test
    public void testReadEverything() throws Exception {
        Assertions.assertEquals((int)97, (int)this.tee.read());
        Assertions.assertEquals((int)98, (int)this.tee.read());
        Assertions.assertEquals((int)99, (int)this.tee.read());
        Assertions.assertEquals((int)-1, (int)this.tee.read());
        Assertions.assertEquals((Object)"abc", (Object)this.output.toString(this.ASCII));
    }

    @Test
    public void testReadNothing() throws Exception {
        Assertions.assertEquals((Object)"", (Object)this.output.toString(this.ASCII));
    }

    @Test
    public void testReadOneByte() throws Exception {
        Assertions.assertEquals((int)97, (int)this.tee.read());
        Assertions.assertEquals((Object)"a", (Object)this.output.toString(this.ASCII));
    }

    @Test
    public void testReadToArray() throws Exception {
        byte[] buffer = new byte[8];
        Assertions.assertEquals((int)3, (int)this.tee.read(buffer));
        Assertions.assertEquals((int)97, (int)buffer[0]);
        Assertions.assertEquals((int)98, (int)buffer[1]);
        Assertions.assertEquals((int)99, (int)buffer[2]);
        Assertions.assertEquals((int)-1, (int)this.tee.read(buffer));
        Assertions.assertEquals((Object)"abc", (Object)this.output.toString(this.ASCII));
    }

    @Test
    public void testReadToArrayWithOffset() throws Exception {
        byte[] buffer = new byte[8];
        Assertions.assertEquals((int)3, (int)this.tee.read(buffer, 4, 4));
        Assertions.assertEquals((int)97, (int)buffer[4]);
        Assertions.assertEquals((int)98, (int)buffer[5]);
        Assertions.assertEquals((int)99, (int)buffer[6]);
        Assertions.assertEquals((int)-1, (int)this.tee.read(buffer, 4, 4));
        Assertions.assertEquals((Object)"abc", (Object)this.output.toString(this.ASCII));
    }

    @Test
    public void testSkip() throws Exception {
        Assertions.assertEquals((int)97, (int)this.tee.read());
        Assertions.assertEquals((long)1L, (long)this.tee.skip(1L));
        Assertions.assertEquals((int)99, (int)this.tee.read());
        Assertions.assertEquals((int)-1, (int)this.tee.read());
        Assertions.assertEquals((Object)"ac", (Object)this.output.toString(this.ASCII));
    }
}

