/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ChecksumInputStream;
import org.apache.commons.io.test.CustomIOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChecksumInputStreamTest {
    private ChecksumInputStream createInputStream() throws IOException {
        return ((ChecksumInputStream.Builder)ChecksumInputStream.builder().setCharSequence("Hi")).setChecksum(new CRC32()).get();
    }

    @Test
    public void testAfterReadConsumer() throws Exception {
        AtomicBoolean boolRef = new AtomicBoolean();
        try (ChecksumInputStream bounded = ((ChecksumInputStream.Builder)((ChecksumInputStream.Builder)ChecksumInputStream.builder().setCharSequence("Hi")).setChecksum(new CRC32()).setExpectedChecksumValue(1293356558L).setAfterRead(i -> boolRef.set(true))).get();){
            IOUtils.consume(bounded);
        }
        Assertions.assertTrue((boolean)boolRef.get());
        String message = "test exception message";
        try (ChecksumInputStream bounded = ((ChecksumInputStream.Builder)((ChecksumInputStream.Builder)ChecksumInputStream.builder().setCharSequence("Hi")).setChecksum(new CRC32()).setExpectedChecksumValue(1293356558L).setAfterRead(i -> {
            throw new CustomIOException("test exception message");
        })).get();){
            Assertions.assertEquals((Object)"test exception message", (Object)((CustomIOException)Assertions.assertThrowsExactly(CustomIOException.class, () -> IOUtils.consume(bounded))).getMessage());
        }
    }

    @Test
    public void testAvailableAfterClose() throws Exception {
        ChecksumInputStream shadow;
        try (ChecksumInputStream in = this.createInputStream();){
            Assertions.assertTrue((((InputStream)in).available() > 0 ? 1 : 0) != 0);
            shadow = in;
        }
        Assertions.assertEquals((int)0, (int)((InputStream)shadow).available());
    }

    @Test
    public void testAvailableAfterOpen() throws Exception {
        try (ChecksumInputStream in = this.createInputStream();){
            Assertions.assertTrue((((InputStream)in).available() > 0 ? 1 : 0) != 0);
            Assertions.assertEquals((int)72, (int)((InputStream)in).read());
            Assertions.assertTrue((((InputStream)in).available() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDefaultThresholdFailure() throws IOException {
        byte[] byteArray = new byte[3];
        Adler32 adler32 = new Adler32();
        try (ChecksumInputStream checksum = ((ChecksumInputStream.Builder)ChecksumInputStream.builder().setByteArray(byteArray)).setChecksum(adler32).setExpectedChecksumValue(-68L).get();){
            Assertions.assertEquals((long)0L, (long)checksum.getByteCount());
            Assertions.assertEquals((long)-1L, (long)checksum.getRemaining());
            Assertions.assertEquals((int)byteArray.length, (int)checksum.read(new byte[byteArray.length + 1]));
            Assertions.assertThrows(IOException.class, () -> checksum.read(new byte[1]));
            Assertions.assertEquals((long)byteArray.length, (long)checksum.getByteCount());
            Assertions.assertEquals((long)-4L, (long)checksum.getRemaining());
        }
    }

    @Test
    public void testDefaultThresholdSuccess() throws IOException {
        Adler32 sanityCheck = new Adler32();
        byte[] byteArray = new byte[3];
        sanityCheck.update(byteArray);
        long expectedChecksum = sanityCheck.getValue();
        Adler32 adler32 = new Adler32();
        try (ChecksumInputStream checksum = ((ChecksumInputStream.Builder)ChecksumInputStream.builder().setByteArray(byteArray)).setChecksum(adler32).setExpectedChecksumValue(expectedChecksum).get();){
            Assertions.assertEquals((long)0L, (long)checksum.getByteCount());
            Assertions.assertEquals((long)-1L, (long)checksum.getRemaining());
            Assertions.assertEquals((int)3, (int)checksum.read(byteArray));
            Assertions.assertEquals((long)byteArray.length, (long)checksum.getByteCount());
            Assertions.assertEquals((long)-4L, (long)checksum.getRemaining());
            Assertions.assertEquals((int)-1, (int)checksum.read(byteArray));
            Assertions.assertEquals((long)byteArray.length, (long)checksum.getByteCount());
            Assertions.assertEquals((long)-4L, (long)checksum.getRemaining());
        }
    }

    @Test
    public void testReadAfterClose() throws Exception {
        ChecksumInputStream shadow;
        try (ChecksumInputStream in = this.createInputStream();){
            Assertions.assertTrue((((InputStream)in).available() > 0 ? 1 : 0) != 0);
            shadow = in;
        }
        Assertions.assertEquals((int)-1, (int)((InputStream)shadow).read());
    }

    @Test
    public void testReadTakingByteArrayThrowsException() throws IOException {
        Adler32 adler32 = new Adler32();
        byte[] byteArray = new byte[3];
        long sizeThreshold = -1859L;
        try (ChecksumInputStream checksum = ((ChecksumInputStream.Builder)ChecksumInputStream.builder().setByteArray(byteArray)).setChecksum(adler32).setExpectedChecksumValue(-68L).setCountThreshold(-1859L).get();){
            Assertions.assertEquals((long)0L, (long)checksum.getByteCount());
            Assertions.assertEquals((long)-1859L, (long)checksum.getRemaining());
            Assertions.assertEquals((int)byteArray.length, (int)checksum.read(new byte[byteArray.length + 1]));
            Assertions.assertThrows(IOException.class, () -> checksum.read(new byte[1]));
            Assertions.assertEquals((long)byteArray.length, (long)checksum.getByteCount());
            Assertions.assertEquals((long)(-1859L - (long)byteArray.length), (long)checksum.getRemaining());
        }
    }

    @Test
    public void testReadTakingNoArgumentsThrowsException() throws IOException {
        CRC32 crc32 = new CRC32();
        byte[] byteArray = new byte[9];
        try (ChecksumInputStream checksum = ((ChecksumInputStream.Builder)ChecksumInputStream.builder().setByteArray(byteArray)).setChecksum(crc32).setExpectedChecksumValue(1L).setCountThreshold(1L).get();){
            Assertions.assertEquals((long)0L, (long)checksum.getByteCount());
            Assertions.assertEquals((long)1L, (long)checksum.getRemaining());
            Assertions.assertThrows(IOException.class, () -> checksum.read());
            Assertions.assertEquals((long)1L, (long)checksum.getByteCount());
            Assertions.assertEquals((long)0L, (long)checksum.getRemaining());
        }
    }

    @Test
    public void testSkip() throws IOException {
        CRC32 sanityCheck = new CRC32();
        byte[] byteArray = new byte[4];
        sanityCheck.update(byteArray);
        long expectedChecksum = sanityCheck.getValue();
        CRC32 crc32 = new CRC32();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
        try (ChecksumInputStream checksum = ((ChecksumInputStream.Builder)ChecksumInputStream.builder().setInputStream(byteArrayInputStream)).setChecksum(crc32).setExpectedChecksumValue(expectedChecksum).setCountThreshold(33L).get();){
            Assertions.assertEquals((long)0L, (long)checksum.getByteCount());
            Assertions.assertEquals((int)4, (int)checksum.read(byteArray));
            Assertions.assertEquals((long)byteArray.length, (long)checksum.getByteCount());
            Assertions.assertEquals((long)29L, (long)checksum.getRemaining());
            long skipReturnValue = checksum.skip(1L);
            Assertions.assertEquals((long)byteArray.length, (long)checksum.getByteCount());
            Assertions.assertEquals((long)29L, (long)checksum.getRemaining());
            Assertions.assertEquals((long)558161692L, (long)crc32.getValue());
            Assertions.assertEquals((int)0, (int)((InputStream)byteArrayInputStream).available());
            Assertions.assertArrayEquals((byte[])new byte[4], (byte[])byteArray);
            Assertions.assertEquals((long)0L, (long)skipReturnValue);
            Assertions.assertEquals((long)29L, (long)checksum.getRemaining());
        }
    }
}

