/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnmappableCharacterException;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.io.input.ReaderInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CharSequenceInputStreamTest {
    private static final String UTF_16 = StandardCharsets.UTF_16.name();
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String LARGE_TEST_STRING;
    private static final String TEST_STRING = "\u00e0 peine arriv\u00e9s nous entr\u00e2mes dans sa chambre";
    private final Random random = new Random();

    private int checkAvail(InputStream is, int min2) throws Exception {
        int available = is.available();
        Assertions.assertTrue((available >= min2 ? 1 : 0) != 0, (String)("avail should be >= " + min2 + ", but was " + available));
        return available;
    }

    private boolean isAvailabilityTestableForCharset(String csName) {
        return Charset.forName(csName).canEncode() && !"COMPOUND_TEXT".equalsIgnoreCase(csName) && !"x-COMPOUND_TEXT".equalsIgnoreCase(csName) && !this.isOddBallLegacyCharsetThatDoesNotSupportFrenchCharacters(csName);
    }

    private boolean isOddBallLegacyCharsetThatDoesNotSupportFrenchCharacters(String csName) {
        return "x-IBM1388".equalsIgnoreCase(csName) || "ISO-2022-CN".equalsIgnoreCase(csName) || "ISO-2022-JP".equalsIgnoreCase(csName) || "Shift_JIS".equalsIgnoreCase(csName);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"org.apache.commons.io.CharsetsTest#availableCharsetsKeySet"})
    public void testAvailable(String csName) throws Exception {
        try {
            if (this.isAvailabilityTestableForCharset(csName)) {
                this.testAvailableSkip(csName);
                this.testAvailableRead(csName);
            }
        }
        catch (UnsupportedOperationException e) {
            Assertions.fail((String)("Operation not supported for " + csName));
        }
    }

    @Test
    public void testAvailableAfterClose() throws Exception {
        CharSequenceInputStream shadow;
        try (CharSequenceInputStream in = ((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence("Hi")).get();){
            Assertions.assertTrue((((InputStream)in).available() > 0 ? 1 : 0) != 0);
            shadow = in;
        }
        Assertions.assertEquals((int)0, (int)((InputStream)shadow).available());
    }

    @Test
    public void testAvailableAfterOpen() throws IOException {
        Charset charset = Charset.forName("Big5");
        try (CharSequenceInputStream in = new CharSequenceInputStream((CharSequence)"\ud800\udc00", charset);){
            int available = in.available();
            byte[] data = new byte[available];
            int bytesRead = in.read(data);
            Assertions.assertEquals((int)available, (int)bytesRead);
        }
    }

    private void testAvailableRead(String csName) throws Exception {
        String input = "test";
        try (CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"test", csName);){
            int available = this.checkAvail(r, "test".length());
            Assertions.assertEquals((long)(available - 1), (long)((InputStream)r).skip(available - 1));
            available = this.checkAvail(r, 1);
            byte[] buff = new byte[available];
            Assertions.assertEquals((int)available, (int)((InputStream)r).read(buff, 0, available));
        }
    }

    private void testAvailableSkip(String csName) throws Exception {
        String input = "test";
        try (CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"test", csName);){
            int available = this.checkAvail(r, "test".length());
            Assertions.assertEquals((long)(available - 1), (long)((InputStream)r).skip(available - 1));
            available = this.checkAvail(r, 1);
            Assertions.assertEquals((long)1L, (long)((InputStream)r).skip(1L));
            available = this.checkAvail(r, 0);
        }
    }

    private void testBufferedRead(String testString, String charsetName) throws IOException {
        byte[] expected = testString.getBytes(charsetName);
        try (CharSequenceInputStream in = new CharSequenceInputStream((CharSequence)testString, charsetName, 512);){
            byte[] buffer = new byte[128];
            int offset = 0;
            block5: while (true) {
                int bufferLength;
                int bufferOffset;
                int read;
                if ((read = ((InputStream)in).read(buffer, bufferOffset = this.random.nextInt(64), bufferLength = this.random.nextInt(64))) == -1) {
                    Assertions.assertEquals((int)expected.length, (int)offset, (String)("EOF: offset should equal length for charset " + charsetName));
                    break;
                }
                Assertions.assertTrue((read <= bufferLength ? 1 : 0) != 0, (String)("Read " + read + " <= " + bufferLength));
                while (true) {
                    if (read <= 0) continue block5;
                    Assertions.assertTrue((offset < expected.length ? 1 : 0) != 0, (String)("offset for " + charsetName + " " + offset + " < " + expected.length));
                    Assertions.assertEquals((byte)expected[offset], (byte)buffer[bufferOffset], (String)("bytes should agree for " + charsetName));
                    ++offset;
                    ++bufferOffset;
                    --read;
                }
                break;
            }
        }
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"org.apache.commons.io.CharsetsTest#availableCharsetsKeySet"})
    public void testBufferedRead_AvailableCharset(String csName) throws IOException {
        if (this.isAvailabilityTestableForCharset(csName)) {
            this.testBufferedRead(TEST_STRING, csName);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.CharsetsTest#getRequiredCharsetNames"})
    public void testBufferedRead_RequiredCharset(String csName) throws IOException {
        this.testBufferedRead(TEST_STRING, csName);
    }

    @Test
    public void testBufferedRead_UTF8() throws IOException {
        this.testBufferedRead(TEST_STRING, UTF_8);
    }

    @Test
    public void testCharacterCodingException() throws IOException {
        Charset charset = StandardCharsets.US_ASCII;
        CharSequenceInputStream in = ((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharsetEncoder(charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPORT)).setCharSequence("\u0080")).get();
        Assertions.assertEquals((int)0, (int)in.available());
        Assertions.assertThrows(UnmappableCharacterException.class, in::read);
    }

    private void testCharsetMismatchInfiniteLoop(String csName) throws IOException {
        char[] inputChars = new char[]{'\u00e0', '\u00b2', '\u00a0'};
        Charset charset = Charset.forName(csName);
        try (CharSequenceInputStream stream = new CharSequenceInputStream((CharSequence)new String(inputChars), charset, 512);){
            IOUtils.toCharArray((InputStream)stream, charset);
        }
        stream = ((CharSequenceInputStream.Builder)((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence(new String(inputChars))).setCharset(charset).setBufferSize(512)).get();
        try {
            IOUtils.toCharArray((InputStream)stream, charset);
        }
        finally {
            if (stream != null) {
                ((InputStream)stream).close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.CharsetsTest#getRequiredCharsetNames"})
    public void testCharsetMismatchInfiniteLoop_RequiredCharsets(String csName) throws IOException {
        this.testCharsetMismatchInfiniteLoop(csName);
    }

    private void testIO_356(int bufferSize, int dataSize, int readFirst, String csName) throws Exception {
        byte[] data2;
        byte[] data1;
        try (CharSequenceInputStream is = new CharSequenceInputStream((CharSequence)ALPHABET, csName, bufferSize);){
            for (int i = 0; i < readFirst; ++i) {
                int ch = is.read();
                Assertions.assertNotEquals((int)-1, (int)ch);
            }
            is.mark(dataSize);
            data1 = new byte[dataSize];
            int readCount1 = is.read(data1);
            Assertions.assertEquals((int)dataSize, (int)readCount1);
            is.reset();
            data2 = new byte[dataSize];
            int readCount2 = is.read(data2);
            Assertions.assertEquals((int)dataSize, (int)readCount2);
        }
        Assertions.assertArrayEquals((byte[])data1, (byte[])data2, (String)("bufferSize=" + bufferSize + " dataSize=" + dataSize));
    }

    @Test
    public void testIO_356_B10_D10_S0_UTF16() throws Exception {
        this.testIO_356(10, 10, 0, UTF_16);
    }

    @Test
    public void testIO_356_B10_D10_S0_UTF8() throws Exception {
        this.testIO_356(10, 10, 0, UTF_8);
    }

    @Test
    public void testIO_356_B10_D10_S1_UTF8() throws Exception {
        this.testIO_356(10, 10, 1, UTF_8);
    }

    @Test
    public void testIO_356_B10_D10_S2_UTF8() throws Exception {
        this.testIO_356(10, 10, 2, UTF_8);
    }

    @Test
    public void testIO_356_B10_D13_S0_UTF8() throws Exception {
        this.testIO_356(10, 13, 0, UTF_8);
    }

    @Test
    public void testIO_356_B10_D13_S1_UTF8() throws Exception {
        this.testIO_356(10, 13, 1, UTF_8);
    }

    @Test
    public void testIO_356_B10_D20_S0_UTF8() throws Exception {
        this.testIO_356(10, 20, 0, UTF_8);
    }

    private void testIO_356_Loop(String csName, int maxBytesPerChar) throws Exception {
        for (int bufferSize = maxBytesPerChar; bufferSize <= 10; ++bufferSize) {
            for (int dataSize = 1; dataSize <= 20; ++dataSize) {
                this.testIO_356(bufferSize, dataSize, 0, csName);
            }
        }
    }

    @Test
    public void testIO_356_Loop_UTF16() throws Exception {
        Charset charset = StandardCharsets.UTF_16;
        this.testIO_356_Loop(charset.displayName(), (int)ReaderInputStream.minBufferSize(charset.newEncoder()));
    }

    @Test
    public void testIO_356_Loop_UTF8() throws Exception {
        Charset charset = StandardCharsets.UTF_8;
        this.testIO_356_Loop(charset.displayName(), (int)ReaderInputStream.minBufferSize(charset.newEncoder()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.CharsetsTest#getRequiredCharsetNames"})
    public void testLargeBufferedRead_RequiredCharsets(String csName) throws IOException {
        this.testBufferedRead(LARGE_TEST_STRING, csName);
    }

    @Test
    public void testLargeBufferedRead_UTF8() throws IOException {
        this.testBufferedRead(LARGE_TEST_STRING, UTF_8);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.CharsetsTest#getRequiredCharsetNames"})
    public void testLargeSingleByteRead_RequiredCharsets(String csName) throws IOException {
        this.testSingleByteRead(LARGE_TEST_STRING, csName);
    }

    @Test
    public void testLargeSingleByteRead_UTF8() throws IOException {
        this.testSingleByteRead(LARGE_TEST_STRING, UTF_8);
    }

    private void testMarkReset(String csName) throws Exception {
        try (CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"test", csName);){
            Assertions.assertEquals((long)2L, (long)((InputStream)r).skip(2L));
            ((InputStream)r).mark(0);
            Assertions.assertEquals((int)115, (int)((InputStream)r).read(), (String)csName);
            Assertions.assertEquals((int)116, (int)((InputStream)r).read(), (String)csName);
            Assertions.assertEquals((int)-1, (int)((InputStream)r).read(), (String)csName);
            ((InputStream)r).reset();
            Assertions.assertEquals((int)115, (int)((InputStream)r).read(), (String)csName);
            Assertions.assertEquals((int)116, (int)((InputStream)r).read(), (String)csName);
            Assertions.assertEquals((int)-1, (int)((InputStream)r).read(), (String)csName);
            ((InputStream)r).reset();
            ((InputStream)r).reset();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.CharsetsTest#getRequiredCharsetNames"})
    public void testMarkReset_RequiredCharsets(String csName) throws Exception {
        this.testMarkResetMultiByteChars(csName);
    }

    @Test
    public void testMarkReset_USASCII() throws Exception {
        this.testMarkReset(StandardCharsets.US_ASCII.name());
    }

    @Test
    public void testMarkReset_UTF8() throws Exception {
        this.testMarkReset(UTF_8);
    }

    private void testMarkResetMultiByteChars(String csName) throws IOException {
        String[] sequences;
        String sequenceEnglish = "Test Sequence";
        String sequenceCJK = "\u4e01\u4f23\u5045\u5167\u5289\u53ab";
        for (String testSequence : sequences = new String[]{"Test Sequence", "\u4e01\u4f23\u5045\u5167\u5289\u53ab"}) {
            CharsetEncoder charsetEncoder = Charset.forName(csName).newEncoder();
            ByteBuffer byteBuffer = ByteBuffer.allocate(testSequence.length() * 3);
            CharBuffer charBuffer = CharBuffer.wrap(testSequence);
            CoderResult result = charsetEncoder.encode(charBuffer, byteBuffer, true);
            if (result.isUnmappable()) continue;
            byte[] expectedBytes = byteBuffer.array();
            int bLength = byteBuffer.position();
            int skip = bLength - 4;
            try (CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)testSequence, csName);){
                Assertions.assertEquals((long)skip, (long)((InputStream)r).skip(skip));
                ((InputStream)r).mark(0);
                Assertions.assertEquals((byte)expectedBytes[bLength - 4], (byte)((byte)((InputStream)r).read()), (String)csName);
                Assertions.assertEquals((byte)expectedBytes[bLength - 3], (byte)((byte)((InputStream)r).read()), (String)csName);
                Assertions.assertEquals((byte)expectedBytes[bLength - 2], (byte)((byte)((InputStream)r).read()), (String)csName);
                Assertions.assertEquals((byte)expectedBytes[bLength - 1], (byte)((byte)((InputStream)r).read()), (String)csName);
                Assertions.assertEquals((int)-1, (int)((byte)((InputStream)r).read()), (String)csName);
                ((InputStream)r).reset();
                Assertions.assertEquals((byte)expectedBytes[bLength - 4], (byte)((byte)((InputStream)r).read()), (String)csName);
                Assertions.assertEquals((byte)expectedBytes[bLength - 3], (byte)((byte)((InputStream)r).read()), (String)csName);
                Assertions.assertEquals((byte)expectedBytes[bLength - 2], (byte)((byte)((InputStream)r).read()), (String)csName);
                Assertions.assertEquals((byte)expectedBytes[bLength - 1], (byte)((byte)((InputStream)r).read()), (String)csName);
                Assertions.assertEquals((int)-1, (int)((byte)((InputStream)r).read()), (String)csName);
                ((InputStream)r).reset();
                Assertions.assertEquals((byte)expectedBytes[bLength - 4], (byte)((byte)((InputStream)r).read()), (String)csName);
                Assertions.assertEquals((byte)expectedBytes[bLength - 3], (byte)((byte)((InputStream)r).read()), (String)csName);
                Assertions.assertEquals((byte)expectedBytes[bLength - 2], (byte)((byte)((InputStream)r).read()), (String)csName);
                Assertions.assertEquals((byte)expectedBytes[bLength - 1], (byte)((byte)((InputStream)r).read()), (String)csName);
                Assertions.assertEquals((int)-1, (int)((byte)((InputStream)r).read()), (String)csName);
            }
        }
    }

    @Test
    public void testMarkSupported() throws Exception {
        try (CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"test", UTF_8);){
            Assertions.assertTrue((boolean)((InputStream)r).markSupported());
        }
        r = ((CharSequenceInputStream.Builder)((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence("test")).setCharset(UTF_8)).get();
        try {
            Assertions.assertTrue((boolean)((InputStream)r).markSupported());
        }
        finally {
            if (r != null) {
                ((InputStream)r).close();
            }
        }
    }

    @Test
    public void testNullCharset() throws IOException {
        try (CharSequenceInputStream in = new CharSequenceInputStream((CharSequence)"A", (Charset)null);){
            IOUtils.toByteArray(in);
            Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)in.getCharsetEncoder().charset());
        }
        in = ((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence("test")).setCharset((Charset)null).get();
        try {
            IOUtils.toByteArray(in);
            Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)in.getCharsetEncoder().charset());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Test
    public void testNullCharsetName() throws IOException {
        try (CharSequenceInputStream in = new CharSequenceInputStream((CharSequence)"A", (String)null);){
            IOUtils.toByteArray(in);
            Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)in.getCharsetEncoder().charset());
        }
        in = ((CharSequenceInputStream.Builder)((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence("test")).setCharset((String)null)).get();
        try {
            IOUtils.toByteArray(in);
            Assertions.assertEquals((Object)Charset.defaultCharset(), (Object)in.getCharsetEncoder().charset());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Test
    public void testReadAfterClose() throws Exception {
        CharSequenceInputStream shadow;
        try (CharSequenceInputStream in = ((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence("Hi")).get();){
            Assertions.assertTrue((((InputStream)in).available() > 0 ? 1 : 0) != 0);
            shadow = in;
        }
        Assertions.assertEquals((int)-1, (int)((InputStream)shadow).read());
    }

    private void testReadZero(String csName) throws Exception {
        try (CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"test", csName);){
            byte[] bytes = new byte[30];
            Assertions.assertEquals((int)0, (int)((InputStream)r).read(bytes, 0, 0));
        }
    }

    @Test
    public void testReadZero_EmptyString() throws Exception {
        try (CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"", UTF_8);){
            byte[] bytes = new byte[30];
            Assertions.assertEquals((int)0, (int)((InputStream)r).read(bytes, 0, 0));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.CharsetsTest#getRequiredCharsetNames"})
    public void testReadZero_RequiredCharsets(String csName) throws Exception {
        this.testReadZero(csName);
    }

    private void testResetBeforeEnd(CharSequenceInputStream inputStream) throws IOException {
        inputStream.mark(1);
        Assertions.assertEquals((int)49, (int)inputStream.read());
        inputStream.reset();
        Assertions.assertEquals((int)49, (int)inputStream.read());
        Assertions.assertEquals((int)50, (int)inputStream.read());
        inputStream.reset();
        Assertions.assertEquals((int)49, (int)inputStream.read());
        Assertions.assertEquals((int)50, (int)inputStream.read());
        Assertions.assertEquals((int)51, (int)inputStream.read());
        inputStream.reset();
        Assertions.assertEquals((int)49, (int)inputStream.read());
        Assertions.assertEquals((int)50, (int)inputStream.read());
        Assertions.assertEquals((int)51, (int)inputStream.read());
        Assertions.assertEquals((int)52, (int)inputStream.read());
        inputStream.reset();
        Assertions.assertEquals((int)49, (int)inputStream.read());
    }

    @Test
    public void testResetBeforeEndSetCharSequence() throws IOException {
        try (CharSequenceInputStream inputStream = ((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence("1234")).get();){
            this.testResetBeforeEnd(inputStream);
        }
    }

    @Test
    public void testResetCharset() {
        Assertions.assertNotNull((Object)((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setReader(new StringReader("\ud800"))).setCharset((Charset)null).getCharset());
    }

    @Test
    public void testResetCharsetEncoder() {
        Assertions.assertNotNull((Object)((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setReader(new StringReader("\ud800"))).setCharsetEncoder(null).getCharsetEncoder());
    }

    @Test
    public void testResetCharsetName() {
        Assertions.assertNotNull((Object)((CharSequenceInputStream.Builder)((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setReader(new StringReader("\ud800"))).setCharset((String)null)).getCharset());
    }

    private void testSingleByteRead(String testString, String charsetName) throws IOException {
        byte[] bytes = testString.getBytes(charsetName);
        try (CharSequenceInputStream in = new CharSequenceInputStream((CharSequence)testString, charsetName, 512);){
            for (byte b : bytes) {
                int read = ((InputStream)in).read();
                Assertions.assertTrue((read >= 0 ? 1 : 0) != 0, (String)("read " + read + " >=0 "));
                Assertions.assertTrue((read <= 255 ? 1 : 0) != 0, (String)("read " + read + " <= 255"));
                Assertions.assertEquals((byte)b, (byte)((byte)read), (String)"Should agree with input");
            }
            Assertions.assertEquals((int)-1, (int)((InputStream)in).read());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.CharsetsTest#getRequiredCharsetNames"})
    public void testSingleByteRead_RequiredCharsets(String csName) throws IOException {
        this.testSingleByteRead(TEST_STRING, csName);
    }

    @Test
    public void testSingleByteRead_UTF16() throws IOException {
        this.testSingleByteRead(TEST_STRING, UTF_16);
    }

    @Test
    public void testSingleByteRead_UTF8() throws IOException {
        this.testSingleByteRead(TEST_STRING, UTF_8);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.io.CharsetsTest#getRequiredCharsetNames"})
    public void testSkip_RequiredCharsets(String csName) throws Exception {
        try (CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"test", csName);){
            Assertions.assertEquals((long)1L, (long)((InputStream)r).skip(1L));
            Assertions.assertEquals((long)2L, (long)((InputStream)r).skip(2L));
            ((InputStream)r).skip(100L);
            Assertions.assertEquals((int)-1, (int)((InputStream)r).read(), (String)csName);
        }
    }

    static {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            buffer.append(TEST_STRING);
        }
        LARGE_TEST_STRING = buffer.toString();
    }
}

