/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.io.function.IOComparator;
import org.apache.commons.io.function.TestConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOComparatorTest {
    static final IOComparator<Path> PATH_SIZE_COMP = (t2, u) -> Long.compare(Files.size(t2), Files.size(u));
    static final IOComparator<Path> REAL_PATH_COMP = (t2, u) -> t2.toRealPath(new LinkOption[0]).compareTo((Path)u);

    @Test
    public void testAsComparator() {
        Assertions.assertEquals((int)0, (int)REAL_PATH_COMP.asComparator().compare(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_A));
        Assertions.assertThrows(UncheckedIOException.class, () -> TestConstants.THROWING_IO_COMPARATOR.asComparator().compare(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_B));
    }

    @Test
    public void testCompareLong() throws IOException {
        Assertions.assertEquals((int)0, (int)REAL_PATH_COMP.compare(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_A));
    }

    @Test
    public void testComparePath() throws IOException {
        Assertions.assertEquals((int)0, (int)PATH_SIZE_COMP.compare(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_A));
    }

    @Test
    public void testThrowing() {
        Assertions.assertThrows(IOException.class, () -> TestConstants.THROWING_IO_COMPARATOR.compare(TestConstants.ABS_PATH_A, TestConstants.ABS_PATH_B));
    }
}

