/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.comparator.AbstractFileComparator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class ComparatorAbstractTest {
    @TempDir
    public File dir;
    protected AbstractFileComparator comparator;
    protected Comparator<File> reverse;
    protected File equalFile1;
    protected File equalFile2;
    protected File lessFile;
    protected File moreFile;

    @Test
    public void testComparator() {
        Assertions.assertEquals((int)0, (int)this.comparator.compare(this.equalFile1, this.equalFile2), (String)"equal");
        Assertions.assertTrue((this.comparator.compare(this.lessFile, this.moreFile) < 0 ? 1 : 0) != 0, (String)"less");
        Assertions.assertTrue((this.comparator.compare(this.moreFile, this.lessFile) > 0 ? 1 : 0) != 0, (String)"more");
    }

    @Test
    public void testReverseComparator() {
        Assertions.assertEquals((int)0, (int)this.reverse.compare(this.equalFile1, this.equalFile2), (String)"equal");
        Assertions.assertTrue((this.reverse.compare(this.moreFile, this.lessFile) < 0 ? 1 : 0) != 0, (String)"less");
        Assertions.assertTrue((this.reverse.compare(this.lessFile, this.moreFile) > 0 ? 1 : 0) != 0, (String)"more");
    }

    @Test
    public void testSortArray() {
        File[] files = new File[]{this.equalFile1, this.moreFile, this.lessFile};
        this.comparator.sort(files);
        Assertions.assertSame((Object)this.lessFile, (Object)files[0], (String)"equal");
        Assertions.assertSame((Object)this.equalFile1, (Object)files[1], (String)"less");
        Assertions.assertSame((Object)this.moreFile, (Object)files[2], (String)"more");
    }

    @Test
    public void testSortArrayNull() {
        Assertions.assertNull((Object)this.comparator.sort((File[])null));
    }

    @Test
    public void testSortList() {
        ArrayList<File> files = new ArrayList<File>();
        files.add(this.equalFile1);
        files.add(this.moreFile);
        files.add(this.lessFile);
        this.comparator.sort(files);
        Assertions.assertSame((Object)this.lessFile, files.get(0), (String)"equal");
        Assertions.assertSame((Object)this.equalFile1, files.get(1), (String)"less");
        Assertions.assertSame((Object)this.moreFile, files.get(2), (String)"more");
    }

    @Test
    public void testSortListNull() {
        Assertions.assertNull(this.comparator.sort((List<File>)null));
    }

    @Test
    public void testToString() {
        Assertions.assertNotNull((Object)this.comparator.toString(), (String)"comparator");
        Assertions.assertTrue((boolean)this.reverse.toString().startsWith("ReverseFileComparator["), (String)"reverse");
    }
}

