/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class FileUtilsWaitForTest {
    private final File NOSUCHFILE = new File("a.b.c.d." + System.currentTimeMillis());

    @Test
    public void testIO_488() throws InterruptedException {
        long start = System.currentTimeMillis();
        AtomicBoolean wasInterrupted = new AtomicBoolean();
        int seconds = 3;
        Thread thread1 = new Thread(() -> {
            Assertions.assertFalse((boolean)FileUtils.waitFor(this.NOSUCHFILE, 3), (String)"Should not find file");
            wasInterrupted.set(Thread.currentThread().isInterrupted());
        });
        thread1.start();
        Thread.sleep(500L);
        thread1.interrupt();
        thread1.join();
        Assertions.assertTrue((boolean)wasInterrupted.get(), (String)"Should have been interrupted");
        long elapsed = System.currentTimeMillis() - start;
        Assertions.assertTrue((elapsed >= 3000L ? 1 : 0) != 0, (String)("Should wait for n seconds, actual: " + elapsed));
    }

    @Test
    @Timeout(value=30L, unit=TimeUnit.MILLISECONDS)
    public void testWaitFor0() {
        Assertions.assertTrue((boolean)FileUtils.waitFor(FileUtils.current(), 0));
    }

    @Test
    @Timeout(value=30L, unit=TimeUnit.MILLISECONDS)
    public void testWaitFor0Absent() {
        Assertions.assertFalse((boolean)FileUtils.waitFor(this.NOSUCHFILE, 0));
    }

    @Test
    @Timeout(value=30L, unit=TimeUnit.MILLISECONDS)
    public void testWaitFor10() {
        Assertions.assertTrue((boolean)FileUtils.waitFor(FileUtils.current(), 10));
    }

    @Test
    @Timeout(value=30L, unit=TimeUnit.MILLISECONDS)
    public void testWaitFor100() {
        Assertions.assertTrue((boolean)FileUtils.waitFor(FileUtils.current(), 100));
    }

    @Test
    @Timeout(value=3L, unit=TimeUnit.SECONDS)
    public void testWaitFor5Absent() {
        long start = System.currentTimeMillis();
        Assertions.assertFalse((boolean)FileUtils.waitFor(this.NOSUCHFILE, 2));
        long elapsed = System.currentTimeMillis() - start;
        Assertions.assertTrue((elapsed >= 2000L ? 1 : 0) != 0, (String)("Must reach timeout - expected 2000, actual: " + elapsed));
    }

    @Test
    @Timeout(value=300L, unit=TimeUnit.MILLISECONDS)
    public void testWaitForNegativeDuration() {
        Assertions.assertTrue((boolean)FileUtils.waitFor(FileUtils.current(), -1));
    }

    @Test
    @Timeout(value=30L, unit=TimeUnit.MILLISECONDS)
    public void testWaitForNegativeDurationAbsent() {
        Assertions.assertFalse((boolean)FileUtils.waitFor(this.NOSUCHFILE, -1));
    }
}

