/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.function.Uncheck;
import org.apache.commons.lang3.function.Consumers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileUtilsListFilesTest {
    @TempDir
    public File temporaryFolder;

    @BeforeEach
    public void setUp() throws Exception {
        File dir = this.temporaryFolder;
        File file = new File(dir, "dummy-build.xml");
        FileUtils.touch(file);
        file = new File(dir, "README");
        FileUtils.touch(file);
        dir = new File(dir, "subdir1");
        dir.mkdirs();
        file = new File(dir, "dummy-build.xml");
        FileUtils.touch(file);
        file = new File(dir, "dummy-readme.txt");
        FileUtils.touch(file);
        dir = new File(dir, "subsubdir1");
        dir.mkdirs();
        file = new File(dir, "dummy-file.txt");
        FileUtils.touch(file);
        file = new File(dir, "dummy-index.html");
        FileUtils.touch(file);
        file = new File(dir, "dummy-indexhtml");
        FileUtils.touch(file);
        dir = dir.getParentFile();
        dir = new File(dir, "CVS");
        dir.mkdirs();
        file = new File(dir, "Entries");
        FileUtils.touch(file);
        file = new File(dir, "Repository");
        FileUtils.touch(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIterateFilesByExtension() {
        Collection<String> fileNames;
        String[] extensions = new String[]{"xml", "txt"};
        Iterator<File> files = FileUtils.iterateFiles(this.temporaryFolder, extensions, false);
        try {
            fileNames = this.toFileNames(files);
            Assertions.assertEquals((int)1, (int)fileNames.size());
            Assertions.assertTrue((boolean)fileNames.contains("dummy-build.xml"));
            Assertions.assertFalse((boolean)fileNames.contains("README"));
            Assertions.assertFalse((boolean)fileNames.contains("dummy-file.txt"));
        }
        finally {
            files.forEachRemaining(Consumers.nop());
        }
        try {
            files = FileUtils.iterateFiles(this.temporaryFolder, extensions, true);
            fileNames = this.toFileNames(files);
            Assertions.assertEquals((int)4, (int)fileNames.size());
            Assertions.assertTrue((boolean)fileNames.contains("dummy-file.txt"));
            Assertions.assertFalse((boolean)fileNames.contains("dummy-index.html"));
        }
        finally {
            files.forEachRemaining(Consumers.nop());
        }
        files = FileUtils.iterateFiles(this.temporaryFolder, null, false);
        try {
            fileNames = this.toFileNames(files);
            Assertions.assertEquals((int)2, (int)fileNames.size());
            Assertions.assertTrue((boolean)fileNames.contains("dummy-build.xml"));
            Assertions.assertTrue((boolean)fileNames.contains("README"));
            Assertions.assertFalse((boolean)fileNames.contains("dummy-file.txt"));
        }
        finally {
            files.forEachRemaining(Consumers.nop());
        }
    }

    @Test
    public void testListFiles() {
        IOFileFilter fileFilter = FileFilterUtils.trueFileFilter();
        Collection<File> files = FileUtils.listFiles(this.temporaryFolder, fileFilter, null);
        Collection<String> fileNames = this.toFileNames(files);
        Assertions.assertTrue((boolean)fileNames.contains("dummy-build.xml"), (String)"'dummy-build.xml' is missing");
        Assertions.assertFalse((boolean)fileNames.contains("dummy-index.html"), (String)"'dummy-index.html' shouldn't be found");
        Assertions.assertFalse((boolean)fileNames.contains("Entries"), (String)"'Entries' shouldn't be found");
        fileFilter = FileFilterUtils.trueFileFilter();
        IOFileFilter dirFilter = FileFilterUtils.notFileFilter(FileFilterUtils.nameFileFilter("CVS"));
        files = FileUtils.listFiles(this.temporaryFolder, fileFilter, dirFilter);
        fileNames = this.toFileNames(files);
        Assertions.assertTrue((boolean)fileNames.contains("dummy-build.xml"), (String)"'dummy-build.xml' is missing");
        Assertions.assertTrue((boolean)fileNames.contains("dummy-index.html"), (String)"'dummy-index.html' is missing");
        Assertions.assertFalse((boolean)fileNames.contains("Entries"), (String)"'Entries' shouldn't be found");
        fileFilter = FileFilterUtils.trueFileFilter();
        dirFilter = FileFilterUtils.makeCVSAware(null);
        files = FileUtils.listFiles(this.temporaryFolder, fileFilter, dirFilter);
        fileNames = this.toFileNames(files);
        Assertions.assertTrue((boolean)fileNames.contains("dummy-build.xml"), (String)"'dummy-build.xml' is missing");
        Assertions.assertTrue((boolean)fileNames.contains("dummy-index.html"), (String)"'dummy-index.html' is missing");
        Assertions.assertFalse((boolean)fileNames.contains("Entries"), (String)"'Entries' shouldn't be found");
        fileFilter = FileFilterUtils.trueFileFilter();
        dirFilter = FileFilterUtils.prefixFileFilter("sub");
        dirFilter = FileFilterUtils.makeCVSAware(dirFilter);
        files = FileUtils.listFiles(this.temporaryFolder, fileFilter, dirFilter);
        fileNames = this.toFileNames(files);
        Assertions.assertTrue((boolean)fileNames.contains("dummy-build.xml"), (String)"'dummy-build.xml' is missing");
        Assertions.assertTrue((boolean)fileNames.contains("dummy-index.html"), (String)"'dummy-index.html' is missing");
        Assertions.assertFalse((boolean)fileNames.contains("Entries"), (String)"'Entries' shouldn't be found");
        Assertions.assertThrows(NullPointerException.class, () -> FileUtils.listFiles(this.temporaryFolder, null, null));
    }

    @Test
    public void testListFilesByExtension() {
        String[] extensions = new String[]{"xml", "txt"};
        Collection<File> files = FileUtils.listFiles(this.temporaryFolder, extensions, false);
        Assertions.assertEquals((int)1, (int)files.size());
        Collection<String> fileNames = this.toFileNames(files);
        Assertions.assertTrue((boolean)fileNames.contains("dummy-build.xml"));
        Assertions.assertFalse((boolean)fileNames.contains("README"));
        Assertions.assertFalse((boolean)fileNames.contains("dummy-file.txt"));
        files = FileUtils.listFiles(this.temporaryFolder, extensions, true);
        fileNames = this.toFileNames(files);
        Assertions.assertEquals((int)4, (int)fileNames.size(), fileNames::toString);
        Assertions.assertTrue((boolean)fileNames.contains("dummy-file.txt"));
        Assertions.assertFalse((boolean)fileNames.contains("dummy-index.html"));
        files = FileUtils.listFiles(this.temporaryFolder, null, false);
        Assertions.assertEquals((int)2, (int)files.size(), files::toString);
        fileNames = this.toFileNames(files);
        Assertions.assertTrue((boolean)fileNames.contains("dummy-build.xml"));
        Assertions.assertTrue((boolean)fileNames.contains("README"));
        Assertions.assertFalse((boolean)fileNames.contains("dummy-file.txt"));
        File directory = new File(this.temporaryFolder, "subdir1/subsubdir1");
        files = FileUtils.listFiles(directory, new String[]{"html"}, false);
        fileNames = this.toFileNames(files);
        Assertions.assertFalse((boolean)files.isEmpty(), directory::toString);
        Assertions.assertTrue((boolean)fileNames.contains("dummy-index.html"));
        Assertions.assertFalse((boolean)fileNames.contains("dummy-indexhtml"));
        files = FileUtils.listFiles(this.temporaryFolder, new String[]{"html"}, true);
        fileNames = this.toFileNames(files);
        Assertions.assertFalse((boolean)files.isEmpty(), this.temporaryFolder::toString);
        Assertions.assertTrue((boolean)fileNames.contains("dummy-index.html"));
        Assertions.assertFalse((boolean)fileNames.contains("dummy-indexhtml"));
    }

    @Test
    public void testListFilesWithDeletion() throws IOException {
        List list;
        String[] extensions = new String[]{"xml", "txt"};
        File xFile = new File(this.temporaryFolder, "x.xml");
        if (!xFile.createNewFile()) {
            Assertions.fail((String)("could not create test file: " + xFile));
        }
        Collection<File> files = FileUtils.listFiles(this.temporaryFolder, extensions, true);
        Assertions.assertEquals((int)5, (int)files.size());
        try (Stream stream = Uncheck.get(() -> FileUtils.streamFiles(this.temporaryFolder, true, extensions));){
            Assertions.assertTrue((boolean)xFile.delete());
            list = stream.collect(Collectors.toList());
            Assertions.assertFalse((boolean)list.contains(xFile), list::toString);
        }
        Assertions.assertEquals((int)4, (int)list.size());
    }

    @Test
    public void testListFilesWithDeletionThreaded() throws ExecutionException, InterruptedException {
        Path tempPath = PathUtils.getTempDirectory().resolve("IO-856");
        File tempDir = tempPath.toFile();
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            Assertions.fail((String)("Could not create file path: " + tempDir.getAbsolutePath()));
        }
        int waitTime = 10000;
        int maxFiles = 500;
        byte[] bytes = "TEST".getBytes(StandardCharsets.UTF_8);
        CompletableFuture<Void> c1 = CompletableFuture.runAsync(() -> {
            long endTime = System.currentTimeMillis() + 10000L;
            int count = 0;
            while (System.currentTimeMillis() < endTime && count < 500) {
                File file = new File(tempDir.getAbsolutePath(), UUID.randomUUID() + ".deletetester");
                file.deleteOnExit();
                try {
                    Files.write(file.toPath(), bytes, new OpenOption[0]);
                    ++count;
                }
                catch (Exception e) {
                    Assertions.fail((String)("Could not create test file: '" + file.getAbsolutePath() + "': " + e), (Throwable)e);
                }
                if (file.delete()) continue;
                Assertions.fail((String)("Could not delete test file: '" + file.getAbsolutePath() + "'"));
            }
        });
        CompletableFuture<Void> c2 = CompletableFuture.runAsync(() -> {
            long endTime = System.currentTimeMillis() + 10000L;
            int max = 0;
            try {
                while (System.currentTimeMillis() < endTime) {
                    Collection<File> files = FileUtils.listFiles(tempDir, new String[]{".deletetester"}, false);
                    Assertions.assertNotNull(files);
                    max = Math.max(max, files.size());
                }
            }
            catch (Exception e) {
                System.out.printf("List size max %,d%n", max);
                Assertions.fail((String)("IO-856 test failure: " + e), (Throwable)e);
                e.printStackTrace();
            }
        });
        c1.get();
        c2.get();
    }

    private Collection<String> toFileNames(Collection<File> files) {
        return files.stream().map(File::getName).collect(Collectors.toList());
    }

    private Collection<String> toFileNames(Iterator<File> files) {
        ArrayList<String> fileNames = new ArrayList<String>();
        files.forEachRemaining(f -> fileNames.add(f.getName()));
        return fileNames;
    }
}

