/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Assert;
import graphql.ExperimentalApi;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLSchema;
import graphql.schema.diffing.Edge;
import graphql.schema.diffing.SchemaGraph;
import graphql.schema.diffing.SchemaGraphFactory;
import graphql.schema.diffing.Vertex;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@ExperimentalApi
public class CyclicSchemaAnalyzer {
    public static List<SchemaCycle> findCycles(GraphQLSchema schema) {
        return CyclicSchemaAnalyzer.findCycles(schema, true);
    }

    public static List<SchemaCycle> findCycles(GraphQLSchema schema, boolean filterOutIntrospectionCycles) {
        FindCyclesImpl findCyclesImpl = new FindCyclesImpl(schema);
        findCyclesImpl.findAllSimpleCyclesImpl();
        List<List<Vertex>> vertexCycles = findCyclesImpl.foundCycles;
        if (filterOutIntrospectionCycles) {
            vertexCycles = vertexCycles.stream().filter(vertices -> {
                for (Vertex vertex : vertices) {
                    if (!Introspection.isIntrospectionTypes(vertex.getName())) continue;
                    return false;
                }
                return true;
            }).collect(Collectors.toList());
        }
        ArrayList<SchemaCycle> result = new ArrayList<SchemaCycle>();
        for (List<Vertex> vertexCycle : vertexCycles) {
            ArrayList<String> stringCycle = new ArrayList<String>();
            for (Vertex vertex : vertexCycle) {
                if (vertex.isOfType("Object") || vertex.isOfType("Interface") || vertex.isOfType("Union")) {
                    stringCycle.add(vertex.getName());
                    continue;
                }
                if (vertex.isOfType("Field")) {
                    String fieldsContainerName = findCyclesImpl.graph.getFieldsContainerForField(vertex).getName();
                    stringCycle.add(fieldsContainerName + "." + vertex.getName());
                    continue;
                }
                if (vertex.isOfType("InputObject")) {
                    stringCycle.add(vertex.getName());
                    continue;
                }
                if (vertex.isOfType("InputField")) {
                    String inputFieldsContainerName = findCyclesImpl.graph.getFieldsContainerForField(vertex).getName();
                    stringCycle.add(inputFieldsContainerName + "." + vertex.getName());
                    continue;
                }
                Assert.assertShouldNeverHappen("unexpected vertex in cycle found: " + vertex, new Object[0]);
            }
            result.add(new SchemaCycle(stringCycle));
        }
        return result;
    }

    private static class FindCyclesImpl {
        private final GraphQLSchema schema;
        private final SchemaGraph graph;
        private Vertex[] iToV = null;
        private Map<Vertex, Integer> vToI = null;
        private Set<Vertex> blocked = null;
        private Map<Vertex, Set<Vertex>> bSets = null;
        private ArrayDeque<Vertex> stack = null;
        private List<Set<Vertex>> foundSCCs = null;
        private int index = 0;
        private Map<Vertex, Integer> vIndex = null;
        private Map<Vertex, Integer> vLowlink = null;
        private ArrayDeque<Vertex> path = null;
        private Set<Vertex> pathSet = null;
        private List<List<Vertex>> foundCycles = new ArrayList<List<Vertex>>();

        public FindCyclesImpl(GraphQLSchema schema) {
            this.schema = schema;
            SchemaGraphFactory schemaGraphFactory = new SchemaGraphFactory();
            this.graph = schemaGraphFactory.createGraph(schema);
            this.iToV = this.graph.getVertices().toArray(new Vertex[0]);
            this.vToI = new LinkedHashMap<Vertex, Integer>();
            this.blocked = new LinkedHashSet<Vertex>();
            this.bSets = new LinkedHashMap<Vertex, Set<Vertex>>();
            this.stack = new ArrayDeque();
            for (int i = 0; i < this.iToV.length; ++i) {
                this.vToI.put(this.iToV[i], i);
            }
        }

        public List<List<Vertex>> findAllSimpleCyclesImpl() {
            GraphAndIndex minSCCGResult;
            int size = this.graph.getVertices().size();
            for (int startIndex = 0; startIndex < size && (minSCCGResult = this.findMinSCSG(startIndex)) != null; ++startIndex) {
                startIndex = minSCCGResult.index;
                SchemaGraph scg = minSCCGResult.graph;
                Vertex startV = this.toV(startIndex);
                for (Edge e : scg.getAdjacentEdges(startV)) {
                    Vertex v = e.getTo();
                    this.blocked.remove(v);
                    this.getBSet(v).clear();
                }
                this.findCyclesInSCG(startIndex, startIndex, scg);
            }
            return this.foundCycles;
        }

        private GraphAndIndex findMinSCSG(int startIndex) {
            this.initMinSCGState();
            List<Set<Vertex>> foundSCCs = this.findSCCS(startIndex);
            int minIndexFound = Integer.MAX_VALUE;
            Set<Vertex> minSCC = null;
            for (Set<Vertex> set : foundSCCs) {
                for (Vertex v2 : set) {
                    int t2 = this.toI(v2);
                    if (t2 >= minIndexFound) continue;
                    minIndexFound = t2;
                    minSCC = set;
                }
            }
            if (minSCC == null) {
                return null;
            }
            SchemaGraph resultGraph = new SchemaGraph();
            for (Vertex v : minSCC) {
                resultGraph.addVertex(v);
            }
            for (Vertex v : minSCC) {
                for (Vertex w : minSCC) {
                    Edge edge = this.graph.getEdge(v, w);
                    if (edge == null) continue;
                    resultGraph.addEdge(edge);
                }
            }
            GraphAndIndex graphAndIndex = new GraphAndIndex(resultGraph, minIndexFound);
            this.clearMinSCCState();
            return graphAndIndex;
        }

        private List<Set<Vertex>> findSCCS(int startIndex) {
            for (Vertex v : this.graph.getVertices()) {
                int vI = this.toI(v);
                if (vI < startIndex || this.vIndex.containsKey(v)) continue;
                this.getSCCs(startIndex, vI);
            }
            List<Set<Vertex>> result = this.foundSCCs;
            this.foundSCCs = null;
            return result;
        }

        private void getSCCs(int startIndex, int vertexIndex) {
            Vertex vertex = this.toV(vertexIndex);
            this.vIndex.put(vertex, this.index);
            this.vLowlink.put(vertex, this.index);
            ++this.index;
            this.path.push(vertex);
            this.pathSet.add(vertex);
            List<Edge> edges = this.graph.getAdjacentEdges(vertex);
            for (Edge e : edges) {
                Vertex successor = e.getTo();
                int successorIndex = this.toI(successor);
                if (successorIndex < startIndex) continue;
                if (!this.vIndex.containsKey(successor)) {
                    this.getSCCs(startIndex, successorIndex);
                    this.vLowlink.put(vertex, Math.min(this.vLowlink.get(vertex), this.vLowlink.get(successor)));
                    continue;
                }
                if (!this.pathSet.contains(successor)) continue;
                this.vLowlink.put(vertex, Math.min(this.vLowlink.get(vertex), this.vIndex.get(successor)));
            }
            if (this.vLowlink.get(vertex).equals(this.vIndex.get(vertex))) {
                Vertex temp;
                LinkedHashSet<Vertex> result = new LinkedHashSet<Vertex>();
                do {
                    temp = this.path.pop();
                    this.pathSet.remove(temp);
                    result.add(temp);
                } while (!vertex.equals(temp));
                if (result.size() == 1) {
                    Vertex v = (Vertex)result.iterator().next();
                    if (this.graph.containsEdge(vertex, v)) {
                        this.foundSCCs.add(result);
                    }
                } else {
                    this.foundSCCs.add(result);
                }
            }
        }

        private boolean findCyclesInSCG(int startIndex, int vertexIndex, SchemaGraph scg) {
            boolean foundCycle = false;
            Vertex vertex = this.toV(vertexIndex);
            this.stack.push(vertex);
            this.blocked.add(vertex);
            for (Edge e : scg.getAdjacentEdges(vertex)) {
                Vertex successor = e.getTo();
                int successorIndex = this.toI(successor);
                if (successorIndex == startIndex) {
                    ArrayList cycle = new ArrayList(this.stack.size());
                    this.stack.descendingIterator().forEachRemaining(cycle::add);
                    this.foundCycles.add(cycle);
                    foundCycle = true;
                    continue;
                }
                if (this.blocked.contains(successor)) continue;
                boolean gotCycle = this.findCyclesInSCG(startIndex, successorIndex, scg);
                foundCycle = foundCycle || gotCycle;
            }
            if (foundCycle) {
                this.unblock(vertex);
            } else {
                for (Edge ew : scg.getAdjacentEdges(vertex)) {
                    Vertex w = ew.getTo();
                    Set<Vertex> bSet = this.getBSet(w);
                    bSet.add(vertex);
                }
            }
            this.stack.pop();
            return foundCycle;
        }

        private void unblock(Vertex vertex) {
            this.blocked.remove(vertex);
            Set<Vertex> bSet = this.getBSet(vertex);
            while (bSet.size() > 0) {
                Vertex w = bSet.iterator().next();
                bSet.remove(w);
                if (!this.blocked.contains(w)) continue;
                this.unblock(w);
            }
        }

        private void initMinSCGState() {
            this.index = 0;
            this.foundSCCs = new ArrayList<Set<Vertex>>();
            this.vIndex = new LinkedHashMap<Vertex, Integer>();
            this.vLowlink = new LinkedHashMap<Vertex, Integer>();
            this.path = new ArrayDeque();
            this.pathSet = new LinkedHashSet<Vertex>();
        }

        private void clearMinSCCState() {
            this.index = 0;
            this.foundSCCs = null;
            this.vIndex = null;
            this.vLowlink = null;
            this.path = null;
            this.pathSet = null;
        }

        private Integer toI(Vertex vertex) {
            return this.vToI.get(vertex);
        }

        private Vertex toV(Integer i) {
            return this.iToV[i];
        }

        private Set<Vertex> getBSet(Vertex v) {
            return this.bSets.computeIfAbsent(v, k -> new LinkedHashSet());
        }
    }

    private static class GraphAndIndex {
        final SchemaGraph graph;
        final int index;

        public GraphAndIndex(SchemaGraph graph, int index) {
            this.graph = graph;
            this.index = index;
        }
    }

    public static class SchemaCycle {
        private final List<String> cycle;

        public SchemaCycle(List<String> cycle) {
            this.cycle = cycle;
        }

        public int size() {
            return this.cycle.size();
        }

        public List<String> getCycle() {
            return this.cycle;
        }

        public String toString() {
            return this.cycle.toString();
        }
    }
}

