package org.openqa.selenium.devtools.v138.target.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A filter used by target query/discovery/auto-attach operations.
 */
@org.openqa.selenium.Beta()
public class FilterEntry {

    private final java.util.Optional<java.lang.Boolean> exclude;

    private final java.util.Optional<java.lang.String> type;

    public FilterEntry(java.util.Optional<java.lang.Boolean> exclude, java.util.Optional<java.lang.String> type) {
        this.exclude = exclude;
        this.type = type;
    }

    /**
     * If set, causes exclusion of matching targets from the list.
     */
    public java.util.Optional<java.lang.Boolean> getExclude() {
        return exclude;
    }

    /**
     * If not present, matches any type.
     */
    public java.util.Optional<java.lang.String> getType() {
        return type;
    }

    private static FilterEntry fromJson(JsonInput input) {
        java.util.Optional<java.lang.Boolean> exclude = java.util.Optional.empty();
        java.util.Optional<java.lang.String> type = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "exclude":
                    exclude = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "type":
                    type = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FilterEntry(exclude, type);
    }
}
