package org.openqa.selenium.devtools.v137.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * An auction involving interest groups is taking place. These events are
 * target-specific.
 */
public class InterestGroupAuctionEventOccurred {

    private final org.openqa.selenium.devtools.v137.network.model.TimeSinceEpoch eventTime;

    private final org.openqa.selenium.devtools.v137.storage.model.InterestGroupAuctionEventType type;

    private final org.openqa.selenium.devtools.v137.storage.model.InterestGroupAuctionId uniqueAuctionId;

    private final java.util.Optional<org.openqa.selenium.devtools.v137.storage.model.InterestGroupAuctionId> parentAuctionId;

    private final java.util.Optional<java.util.Map<String, Object>> auctionConfig;

    public InterestGroupAuctionEventOccurred(org.openqa.selenium.devtools.v137.network.model.TimeSinceEpoch eventTime, org.openqa.selenium.devtools.v137.storage.model.InterestGroupAuctionEventType type, org.openqa.selenium.devtools.v137.storage.model.InterestGroupAuctionId uniqueAuctionId, java.util.Optional<org.openqa.selenium.devtools.v137.storage.model.InterestGroupAuctionId> parentAuctionId, java.util.Optional<java.util.Map<String, Object>> auctionConfig) {
        this.eventTime = java.util.Objects.requireNonNull(eventTime, "eventTime is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.uniqueAuctionId = java.util.Objects.requireNonNull(uniqueAuctionId, "uniqueAuctionId is required");
        this.parentAuctionId = parentAuctionId;
        this.auctionConfig = auctionConfig;
    }

    public org.openqa.selenium.devtools.v137.network.model.TimeSinceEpoch getEventTime() {
        return eventTime;
    }

    public org.openqa.selenium.devtools.v137.storage.model.InterestGroupAuctionEventType getType() {
        return type;
    }

    public org.openqa.selenium.devtools.v137.storage.model.InterestGroupAuctionId getUniqueAuctionId() {
        return uniqueAuctionId;
    }

    /**
     * Set for child auctions.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v137.storage.model.InterestGroupAuctionId> getParentAuctionId() {
        return parentAuctionId;
    }

    /**
     * Set for started and configResolved
     */
    public java.util.Optional<java.util.Map<String, Object>> getAuctionConfig() {
        return auctionConfig;
    }

    private static InterestGroupAuctionEventOccurred fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v137.network.model.TimeSinceEpoch eventTime = null;
        org.openqa.selenium.devtools.v137.storage.model.InterestGroupAuctionEventType type = null;
        org.openqa.selenium.devtools.v137.storage.model.InterestGroupAuctionId uniqueAuctionId = null;
        java.util.Optional<org.openqa.selenium.devtools.v137.storage.model.InterestGroupAuctionId> parentAuctionId = java.util.Optional.empty();
        java.util.Optional<java.util.Map<String, Object>> auctionConfig = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "eventTime":
                    eventTime = input.read(org.openqa.selenium.devtools.v137.network.model.TimeSinceEpoch.class);
                    break;
                case "type":
                    type = input.read(org.openqa.selenium.devtools.v137.storage.model.InterestGroupAuctionEventType.class);
                    break;
                case "uniqueAuctionId":
                    uniqueAuctionId = input.read(org.openqa.selenium.devtools.v137.storage.model.InterestGroupAuctionId.class);
                    break;
                case "parentAuctionId":
                    parentAuctionId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v137.storage.model.InterestGroupAuctionId.class));
                    break;
                case "auctionConfig":
                    auctionConfig = java.util.Optional.ofNullable((java.util.Map<String, Object>) input.read(java.util.Map.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new InterestGroupAuctionEventOccurred(eventTime, type, uniqueAuctionId, parentAuctionId, auctionConfig);
    }
}
