package org.openqa.selenium.devtools.v137.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Corresponds to SpeculationRuleSet
 */
public class RuleSet {

    private final org.openqa.selenium.devtools.v137.preload.model.RuleSetId id;

    private final org.openqa.selenium.devtools.v137.network.model.LoaderId loaderId;

    private final java.lang.String sourceText;

    private final java.util.Optional<org.openqa.selenium.devtools.v137.dom.model.BackendNodeId> backendNodeId;

    private final java.util.Optional<java.lang.String> url;

    private final java.util.Optional<org.openqa.selenium.devtools.v137.network.model.RequestId> requestId;

    private final java.util.Optional<org.openqa.selenium.devtools.v137.preload.model.RuleSetErrorType> errorType;

    private final java.util.Optional<java.lang.String> errorMessage;

    public RuleSet(org.openqa.selenium.devtools.v137.preload.model.RuleSetId id, org.openqa.selenium.devtools.v137.network.model.LoaderId loaderId, java.lang.String sourceText, java.util.Optional<org.openqa.selenium.devtools.v137.dom.model.BackendNodeId> backendNodeId, java.util.Optional<java.lang.String> url, java.util.Optional<org.openqa.selenium.devtools.v137.network.model.RequestId> requestId, java.util.Optional<org.openqa.selenium.devtools.v137.preload.model.RuleSetErrorType> errorType, java.util.Optional<java.lang.String> errorMessage) {
        this.id = java.util.Objects.requireNonNull(id, "id is required");
        this.loaderId = java.util.Objects.requireNonNull(loaderId, "loaderId is required");
        this.sourceText = java.util.Objects.requireNonNull(sourceText, "sourceText is required");
        this.backendNodeId = backendNodeId;
        this.url = url;
        this.requestId = requestId;
        this.errorType = errorType;
        this.errorMessage = errorMessage;
    }

    public org.openqa.selenium.devtools.v137.preload.model.RuleSetId getId() {
        return id;
    }

    /**
     * Identifies a document which the rule set is associated with.
     */
    public org.openqa.selenium.devtools.v137.network.model.LoaderId getLoaderId() {
        return loaderId;
    }

    /**
     * Source text of JSON representing the rule set. If it comes from
     * `script` tag, it is the textContent of the node. Note that it is
     * a JSON for valid case.
     *
     * See also:
     * - https://wicg.github.io/nav-speculation/speculation-rules.html
     * - https://github.com/WICG/nav-speculation/blob/main/triggers.md
     */
    public java.lang.String getSourceText() {
        return sourceText;
    }

    /**
     * A speculation rule set is either added through an inline
     * `script` tag or through an external resource via the
     * 'Speculation-Rules' HTTP header. For the first case, we include
     * the BackendNodeId of the relevant `script` tag. For the second
     * case, we include the external URL where the rule set was loaded
     * from, and also RequestId if Network domain is enabled.
     *
     * See also:
     * - https://wicg.github.io/nav-speculation/speculation-rules.html#speculation-rules-script
     * - https://wicg.github.io/nav-speculation/speculation-rules.html#speculation-rules-header
     */
    public java.util.Optional<org.openqa.selenium.devtools.v137.dom.model.BackendNodeId> getBackendNodeId() {
        return backendNodeId;
    }

    public java.util.Optional<java.lang.String> getUrl() {
        return url;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v137.network.model.RequestId> getRequestId() {
        return requestId;
    }

    /**
     * Error information
     * `errorMessage` is null iff `errorType` is null.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v137.preload.model.RuleSetErrorType> getErrorType() {
        return errorType;
    }

    /**
     * TODO(https://crbug.com/1425354): Replace this property with structured error.
     */
    @Deprecated()
    public java.util.Optional<java.lang.String> getErrorMessage() {
        return errorMessage;
    }

    private static RuleSet fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v137.preload.model.RuleSetId id = null;
        org.openqa.selenium.devtools.v137.network.model.LoaderId loaderId = null;
        java.lang.String sourceText = null;
        java.util.Optional<org.openqa.selenium.devtools.v137.dom.model.BackendNodeId> backendNodeId = java.util.Optional.empty();
        java.util.Optional<java.lang.String> url = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v137.network.model.RequestId> requestId = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v137.preload.model.RuleSetErrorType> errorType = java.util.Optional.empty();
        java.util.Optional<java.lang.String> errorMessage = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "id":
                    id = input.read(org.openqa.selenium.devtools.v137.preload.model.RuleSetId.class);
                    break;
                case "loaderId":
                    loaderId = input.read(org.openqa.selenium.devtools.v137.network.model.LoaderId.class);
                    break;
                case "sourceText":
                    sourceText = input.nextString();
                    break;
                case "backendNodeId":
                    backendNodeId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v137.dom.model.BackendNodeId.class));
                    break;
                case "url":
                    url = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "requestId":
                    requestId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v137.network.model.RequestId.class));
                    break;
                case "errorType":
                    errorType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v137.preload.model.RuleSetErrorType.class));
                    break;
                case "errorMessage":
                    errorMessage = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new RuleSet(id, loaderId, sourceText, backendNodeId, url, requestId, errorType, errorMessage);
    }
}
