package org.openqa.selenium.devtools.v137.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Additional information about the frame document's security origin.
 */
@org.openqa.selenium.Beta()
public class SecurityOriginDetails {

    private final java.lang.Boolean isLocalhost;

    public SecurityOriginDetails(java.lang.Boolean isLocalhost) {
        this.isLocalhost = java.util.Objects.requireNonNull(isLocalhost, "isLocalhost is required");
    }

    /**
     * Indicates whether the frame document's security origin is one
     * of the local hostnames (e.g. "localhost") or IP addresses (IPv4
     * 127.0.0.0/8 or IPv6 ::1).
     */
    public java.lang.Boolean getIsLocalhost() {
        return isLocalhost;
    }

    private static SecurityOriginDetails fromJson(JsonInput input) {
        java.lang.Boolean isLocalhost = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "isLocalhost":
                    isLocalhost = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SecurityOriginDetails(isLocalhost);
    }
}
