/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v139.bluetoothemulation;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v139.bluetoothemulation.model.CentralState;
import org.openqa.selenium.devtools.v139.bluetoothemulation.model.CharacteristicOperationReceived;
import org.openqa.selenium.devtools.v139.bluetoothemulation.model.CharacteristicOperationType;
import org.openqa.selenium.devtools.v139.bluetoothemulation.model.CharacteristicProperties;
import org.openqa.selenium.devtools.v139.bluetoothemulation.model.DescriptorOperationReceived;
import org.openqa.selenium.devtools.v139.bluetoothemulation.model.DescriptorOperationType;
import org.openqa.selenium.devtools.v139.bluetoothemulation.model.GATTOperationType;
import org.openqa.selenium.devtools.v139.bluetoothemulation.model.GattOperationReceived;
import org.openqa.selenium.devtools.v139.bluetoothemulation.model.ManufacturerData;
import org.openqa.selenium.devtools.v139.bluetoothemulation.model.ScanEntry;

@Beta
public class BluetoothEmulation {
    public static Command<Void> enable(CentralState state, Boolean leSupported) {
        Objects.requireNonNull(state, "state is required");
        Objects.requireNonNull(leSupported, "leSupported is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("state", (Object)state);
        params.put("leSupported", leSupported);
        return new Command("BluetoothEmulation.enable", Map.copyOf(params));
    }

    public static Command<Void> setSimulatedCentralState(CentralState state) {
        Objects.requireNonNull(state, "state is required");
        LinkedHashMap<String, CentralState> params = new LinkedHashMap<String, CentralState>();
        params.put("state", state);
        return new Command("BluetoothEmulation.setSimulatedCentralState", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("BluetoothEmulation.disable", Map.copyOf(params));
    }

    public static Command<Void> simulatePreconnectedPeripheral(String address, String name, List<ManufacturerData> manufacturerData, List<String> knownServiceUuids) {
        Objects.requireNonNull(address, "address is required");
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(manufacturerData, "manufacturerData is required");
        Objects.requireNonNull(knownServiceUuids, "knownServiceUuids is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("address", address);
        params.put("name", name);
        params.put("manufacturerData", manufacturerData);
        params.put("knownServiceUuids", knownServiceUuids);
        return new Command("BluetoothEmulation.simulatePreconnectedPeripheral", Map.copyOf(params));
    }

    public static Command<Void> simulateAdvertisement(ScanEntry entry) {
        Objects.requireNonNull(entry, "entry is required");
        LinkedHashMap<String, ScanEntry> params = new LinkedHashMap<String, ScanEntry>();
        params.put("entry", entry);
        return new Command("BluetoothEmulation.simulateAdvertisement", Map.copyOf(params));
    }

    public static Command<Void> simulateGATTOperationResponse(String address, GATTOperationType type, Integer code) {
        Objects.requireNonNull(address, "address is required");
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(code, "code is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("address", address);
        params.put("type", (Object)type);
        params.put("code", code);
        return new Command("BluetoothEmulation.simulateGATTOperationResponse", Map.copyOf(params));
    }

    public static Command<Void> simulateCharacteristicOperationResponse(String characteristicId, CharacteristicOperationType type, Integer code, Optional<String> data) {
        Objects.requireNonNull(characteristicId, "characteristicId is required");
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(code, "code is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("characteristicId", characteristicId);
        params.put("type", (Object)type);
        params.put("code", code);
        data.ifPresent(p -> params.put("data", p));
        return new Command("BluetoothEmulation.simulateCharacteristicOperationResponse", Map.copyOf(params));
    }

    public static Command<Void> simulateDescriptorOperationResponse(String descriptorId, DescriptorOperationType type, Integer code, Optional<String> data) {
        Objects.requireNonNull(descriptorId, "descriptorId is required");
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(code, "code is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("descriptorId", descriptorId);
        params.put("type", (Object)type);
        params.put("code", code);
        data.ifPresent(p -> params.put("data", p));
        return new Command("BluetoothEmulation.simulateDescriptorOperationResponse", Map.copyOf(params));
    }

    public static Command<String> addService(String address, String serviceUuid) {
        Objects.requireNonNull(address, "address is required");
        Objects.requireNonNull(serviceUuid, "serviceUuid is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("address", address);
        params.put("serviceUuid", serviceUuid);
        return new Command("BluetoothEmulation.addService", Map.copyOf(params), ConverterFunctions.map((String)"serviceId", String.class));
    }

    public static Command<Void> removeService(String serviceId) {
        Objects.requireNonNull(serviceId, "serviceId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("serviceId", serviceId);
        return new Command("BluetoothEmulation.removeService", Map.copyOf(params));
    }

    public static Command<String> addCharacteristic(String serviceId, String characteristicUuid, CharacteristicProperties properties) {
        Objects.requireNonNull(serviceId, "serviceId is required");
        Objects.requireNonNull(characteristicUuid, "characteristicUuid is required");
        Objects.requireNonNull(properties, "properties is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("serviceId", serviceId);
        params.put("characteristicUuid", characteristicUuid);
        params.put("properties", properties);
        return new Command("BluetoothEmulation.addCharacteristic", Map.copyOf(params), ConverterFunctions.map((String)"characteristicId", String.class));
    }

    public static Command<Void> removeCharacteristic(String characteristicId) {
        Objects.requireNonNull(characteristicId, "characteristicId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("characteristicId", characteristicId);
        return new Command("BluetoothEmulation.removeCharacteristic", Map.copyOf(params));
    }

    public static Command<String> addDescriptor(String characteristicId, String descriptorUuid) {
        Objects.requireNonNull(characteristicId, "characteristicId is required");
        Objects.requireNonNull(descriptorUuid, "descriptorUuid is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("characteristicId", characteristicId);
        params.put("descriptorUuid", descriptorUuid);
        return new Command("BluetoothEmulation.addDescriptor", Map.copyOf(params), ConverterFunctions.map((String)"descriptorId", String.class));
    }

    public static Command<Void> removeDescriptor(String descriptorId) {
        Objects.requireNonNull(descriptorId, "descriptorId is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("descriptorId", descriptorId);
        return new Command("BluetoothEmulation.removeDescriptor", Map.copyOf(params));
    }

    public static Command<Void> simulateGATTDisconnection(String address) {
        Objects.requireNonNull(address, "address is required");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("address", address);
        return new Command("BluetoothEmulation.simulateGATTDisconnection", Map.copyOf(params));
    }

    public static Event<GattOperationReceived> gattOperationReceived() {
        return new Event("BluetoothEmulation.gattOperationReceived", input -> (GattOperationReceived)input.read(GattOperationReceived.class));
    }

    public static Event<CharacteristicOperationReceived> characteristicOperationReceived() {
        return new Event("BluetoothEmulation.characteristicOperationReceived", input -> (CharacteristicOperationReceived)input.read(CharacteristicOperationReceived.class));
    }

    public static Event<DescriptorOperationReceived> descriptorOperationReceived() {
        return new Event("BluetoothEmulation.descriptorOperationReceived", input -> (DescriptorOperationReceived)input.read(DescriptorOperationReceived.class));
    }
}

