/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<cv::Size>"})
@Properties(inherit={opencv_core.class})
public class SizeVector
extends Pointer {
    public SizeVector(Pointer p) {
        super(p);
    }

    public SizeVector(Size value) {
        this(1L);
        this.put(0L, value);
    }

    public SizeVector(Size ... array) {
        this(array.length);
        this.put(array);
    }

    public SizeVector() {
        this.allocate();
    }

    public SizeVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native SizeVector put(@ByRef SizeVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public Size front() {
        return this.get(0L);
    }

    public Size back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    @ByRef
    public native Size get(@Cast(value={"size_t"}) long var1);

    public native SizeVector put(@Cast(value={"size_t"}) long var1, Size var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef Size var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Size[] get() {
        Size[] array = new Size[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.get());
    }

    public Size pop_back() {
        long size = this.size();
        Size value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public SizeVector push_back(Size value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public SizeVector put(Size value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public SizeVector put(Size ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @ByRef
        @Const
        public native Size get();
    }
}

