/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.BooleanCoercer;
import org.openqa.selenium.json.CollectionCoercer;
import org.openqa.selenium.json.EnumCoercer;
import org.openqa.selenium.json.InstanceCoercer;
import org.openqa.selenium.json.InstantCoercer;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonType;
import org.openqa.selenium.json.MapCoercer;
import org.openqa.selenium.json.NumberCoercer;
import org.openqa.selenium.json.ObjectCoercer;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.StaticInitializerCoercer;
import org.openqa.selenium.json.StringCoercer;
import org.openqa.selenium.json.TypeCoercer;
import org.openqa.selenium.json.Types;
import org.openqa.selenium.json.UriCoercer;
import org.openqa.selenium.json.UrlCoercer;
import org.openqa.selenium.json.UuidCoercer;

class JsonTypeCoercer {
    private final Set<TypeCoercer<?>> additionalCoercers;
    private final Set<TypeCoercer<?>> coercers;
    private final Map<Type, BiFunction<JsonInput, PropertySetting, Object>> knownCoercers = new ConcurrentHashMap<Type, BiFunction<JsonInput, PropertySetting, Object>>();

    JsonTypeCoercer() {
        this(Stream.of(new TypeCoercer[0]));
    }

    JsonTypeCoercer(JsonTypeCoercer coercer, Iterable<TypeCoercer<?>> coercers) {
        this(Stream.concat(StreamSupport.stream(coercers.spliterator(), false), coercer.additionalCoercers.stream()));
    }

    private JsonTypeCoercer(Stream<TypeCoercer<?>> coercers) {
        this.additionalCoercers = coercers.collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
        LinkedHashSet builder = new LinkedHashSet(this.additionalCoercers);
        builder.add(new BooleanCoercer());
        builder.add(new NumberCoercer<Byte>(Byte.class, Number::byteValue));
        builder.add(new NumberCoercer<Double>(Double.class, Number::doubleValue));
        builder.add(new NumberCoercer<Float>(Float.class, Number::floatValue));
        builder.add(new NumberCoercer<Integer>(Integer.class, Number::intValue));
        builder.add(new NumberCoercer<Long>(Long.class, Number::longValue));
        builder.add(new NumberCoercer<Number>(Number.class, num -> {
            double doubleValue = num.doubleValue();
            if (doubleValue % 1.0 != 0.0 || doubleValue > 9.223372036854776E18) {
                return doubleValue;
            }
            return num.longValue();
        }));
        builder.add(new NumberCoercer<Short>(Short.class, Number::shortValue));
        builder.add(new StringCoercer());
        builder.add(new EnumCoercer());
        builder.add(new UriCoercer());
        builder.add(new UrlCoercer());
        builder.add(new UuidCoercer());
        builder.add(new InstantCoercer());
        builder.add(new MapCoercer<MutableCapabilities>(Capabilities.class, this, Collector.of(MutableCapabilities::new, (caps, entry) -> caps.setCapability((String)entry.getKey(), entry.getValue()), MutableCapabilities::merge, Collector.Characteristics.UNORDERED)));
        builder.add(new CollectionCoercer<List>(List.class, this, Collectors.toCollection(ArrayList::new)));
        builder.add(new CollectionCoercer<Set>(Set.class, this, Collectors.toCollection(HashSet::new)));
        builder.add(new StaticInitializerCoercer());
        builder.add(new MapCoercer<LinkedHashMap>(Map.class, this, Collector.of(LinkedHashMap::new, (map, entry) -> map.put(entry.getKey(), entry.getValue()), (l, r) -> {
            l.putAll(r);
            return l;
        }, new Collector.Characteristics[0])));
        builder.add(new ObjectCoercer(this));
        builder.add(new InstanceCoercer(this));
        this.coercers = Collections.unmodifiableSet(builder);
    }

    <T> T coerce(JsonInput json, Type typeOfT, PropertySetting setter) {
        BiFunction coercer = this.knownCoercers.computeIfAbsent(typeOfT, this::buildCoercer);
        Object result = Require.nonNull("Coercer", coercer).apply(json, setter);
        return (T)result;
    }

    private BiFunction<JsonInput, PropertySetting, Object> buildCoercer(Type type) {
        return this.coercers.stream().filter(coercer -> coercer.test(Types.narrow(type))).findFirst().map(coercer -> coercer.apply(type)).map(func -> (jsonInput, setter) -> {
            if (jsonInput.peek() == JsonType.NULL) {
                return jsonInput.nextNull();
            }
            return func.apply(jsonInput, setter);
        }).orElseThrow(() -> new JsonException("Unable to find type coercer for " + String.valueOf(type)));
    }
}

