/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader.reactive;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.dataloader.Try;
import org.dataloader.impl.Assertions;
import org.dataloader.reactive.ReactiveSupport;
import org.dataloader.stats.context.IncrementBatchLoadExceptionCountStatisticsContext;
import org.dataloader.stats.context.IncrementLoadErrorCountStatisticsContext;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

abstract class AbstractBatchSubscriber<K, V, T>
implements Subscriber<T> {
    final CompletableFuture<List<V>> valuesFuture;
    final List<K> keys;
    final List<Object> callContexts;
    final List<CompletableFuture<V>> queuedFutures;
    final ReactiveSupport.HelperIntegration<K> helperIntegration;
    List<K> clearCacheKeys = new ArrayList<K>();
    List<V> completedValues = new ArrayList<V>();
    boolean onErrorCalled = false;
    boolean onCompleteCalled = false;

    AbstractBatchSubscriber(CompletableFuture<List<V>> valuesFuture, List<K> keys, List<Object> callContexts, List<CompletableFuture<V>> queuedFutures, ReactiveSupport.HelperIntegration<K> helperIntegration) {
        this.valuesFuture = valuesFuture;
        this.keys = keys;
        this.callContexts = callContexts;
        this.queuedFutures = queuedFutures;
        this.helperIntegration = helperIntegration;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        subscription.request(this.keys.size());
    }

    @Override
    public void onNext(T v) {
        Assertions.assertState(!this.onErrorCalled, () -> "onError has already been called; onNext may not be invoked.");
        Assertions.assertState(!this.onCompleteCalled, () -> "onComplete has already been called; onNext may not be invoked.");
    }

    @Override
    public void onComplete() {
        Assertions.assertState(!this.onErrorCalled, () -> "onError has already been called; onComplete may not be invoked.");
        this.onCompleteCalled = true;
    }

    @Override
    public void onError(Throwable throwable) {
        Assertions.assertState(!this.onCompleteCalled, () -> "onComplete has already been called; onError may not be invoked.");
        this.onErrorCalled = true;
        this.helperIntegration.getStats().incrementBatchLoadExceptionCount(new IncrementBatchLoadExceptionCountStatisticsContext<K>(this.keys, this.callContexts));
    }

    void onNextValue(K key, V value, Object callContext, List<CompletableFuture<V>> futures) {
        if (value instanceof Try) {
            Try tryValue = (Try)value;
            if (tryValue.isSuccess()) {
                futures.forEach(f -> f.complete(tryValue.get()));
            } else {
                this.helperIntegration.getStats().incrementLoadErrorCount(new IncrementLoadErrorCountStatisticsContext<K>(key, callContext));
                futures.forEach(f -> f.completeExceptionally(tryValue.getThrowable()));
                this.clearCacheKeys.add(key);
            }
        } else {
            futures.forEach(f -> f.complete(value));
        }
    }

    Throwable unwrapThrowable(Throwable ex) {
        if (ex instanceof CompletionException) {
            ex = ex.getCause();
        }
        return ex;
    }

    void possiblyClearCacheEntriesOnExceptions() {
        this.helperIntegration.clearCacheEntriesOnExceptions(this.clearCacheKeys);
    }
}

