/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.conditional;

import graphql.Assert;
import graphql.Directives;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.execution.conditional.ConditionalNodeDecision;
import graphql.execution.conditional.ConditionalNodeDecisionEnvironment;
import graphql.language.Argument;
import graphql.language.BooleanValue;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.NodeUtil;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;

@Internal
public class ConditionalNodes {
    public Boolean shouldIncludeWithoutVariables(DirectivesContainer<?> element) {
        return this.shouldInclude(null, element.getDirectives());
    }

    public boolean shouldInclude(DirectivesContainer<?> element, Map<String, Object> variables, GraphQLSchema graphQLSchema, @Nullable GraphQLContext graphQLContext) {
        ConditionalNodeDecision conditionalDecision;
        if (!this.shouldInclude(variables, element.getDirectives()).booleanValue()) {
            return false;
        }
        if (graphQLContext != null && (conditionalDecision = (ConditionalNodeDecision)graphQLContext.get(ConditionalNodeDecision.class)) != null) {
            return this.customShouldInclude(variables, element, graphQLSchema, graphQLContext, conditionalDecision);
        }
        return true;
    }

    private boolean customShouldInclude(Map<String, Object> variables, final DirectivesContainer<?> element, final GraphQLSchema graphQLSchema, final GraphQLContext graphQLContext, ConditionalNodeDecision conditionalDecision) {
        final CoercedVariables coercedVariables = CoercedVariables.of(variables);
        return conditionalDecision.shouldInclude(new ConditionalNodeDecisionEnvironment(){

            @Override
            public DirectivesContainer<?> getDirectivesContainer() {
                return element;
            }

            @Override
            public CoercedVariables getVariables() {
                return coercedVariables;
            }

            @Override
            public GraphQLSchema getGraphQlSchema() {
                return graphQLSchema;
            }

            @Override
            public GraphQLContext getGraphQLContext() {
                return graphQLContext;
            }
        });
    }

    private @Nullable Boolean shouldInclude(Map<String, Object> variables, List<Directive> directives) {
        if (directives.isEmpty()) {
            return true;
        }
        Boolean skip = this.getDirectiveResult(variables, directives, Directives.SkipDirective.getName(), false);
        if (skip == null) {
            return null;
        }
        if (skip.booleanValue()) {
            return false;
        }
        return this.getDirectiveResult(variables, directives, Directives.IncludeDirective.getName(), true);
    }

    public boolean containsSkipOrIncludeDirective(DirectivesContainer<?> directivesContainer) {
        return NodeUtil.findNodeByName(directivesContainer.getDirectives(), Directives.SkipDirective.getName()) != null || NodeUtil.findNodeByName(directivesContainer.getDirectives(), Directives.IncludeDirective.getName()) != null;
    }

    public String getSkipVariableName(DirectivesContainer<?> directivesContainer) {
        Directive skipDirective = NodeUtil.findNodeByName(directivesContainer.getDirectives(), Directives.SkipDirective.getName());
        if (skipDirective == null) {
            return null;
        }
        Argument argument = skipDirective.getArgument("if");
        if (argument.getValue() instanceof VariableReference) {
            return ((VariableReference)argument.getValue()).getName();
        }
        return null;
    }

    public String getIncludeVariableName(DirectivesContainer<?> directivesContainer) {
        Directive skipDirective = NodeUtil.findNodeByName(directivesContainer.getDirectives(), Directives.IncludeDirective.getName());
        if (skipDirective == null) {
            return null;
        }
        Argument argument = skipDirective.getArgument("if");
        if (argument.getValue() instanceof VariableReference) {
            return ((VariableReference)argument.getValue()).getName();
        }
        return null;
    }

    private @Nullable Boolean getDirectiveResult(Map<String, Object> variables, List<Directive> directives, String directiveName, boolean defaultValue) {
        Directive foundDirective = NodeUtil.findNodeByName(directives, directiveName);
        if (foundDirective != null) {
            return this.getIfValue(foundDirective.getArguments(), variables);
        }
        return defaultValue;
    }

    private @Nullable Boolean getIfValue(List<Argument> arguments, @Nullable Map<String, Object> variables) {
        for (Argument argument : arguments) {
            if (!argument.getName().equals("if")) continue;
            Value value = argument.getValue();
            if (value instanceof BooleanValue) {
                return ((BooleanValue)value).isValue();
            }
            if (value instanceof VariableReference && variables != null) {
                return (boolean)((Boolean)variables.get(((VariableReference)value).getName()));
            }
            return null;
        }
        return (Boolean)Assert.assertShouldNeverHappen("The 'if' argument must be present", new Object[0]);
    }
}

