/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Internal;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.NonNullableFieldWasNullError;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.ResultPath;

@Internal
public class NonNullableFieldValidator {
    private final ExecutionContext executionContext;

    public NonNullableFieldValidator(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public <T> T validate(ExecutionStrategyParameters parameters, T result) throws NonNullableFieldWasNullException {
        ExecutionStepInfo executionStepInfo;
        if (result == null && (executionStepInfo = parameters.getExecutionStepInfo()).isNonNullType()) {
            ResultPath path = parameters.getPath();
            NonNullableFieldWasNullException nonNullException = new NonNullableFieldWasNullException(executionStepInfo, path);
            NonNullableFieldWasNullError error = new NonNullableFieldWasNullError(nonNullException);
            if (parameters.getDeferredCallContext() != null) {
                parameters.getDeferredCallContext().addError(error);
            } else {
                this.executionContext.addError(error, path);
            }
            if (this.executionContext.propagateErrorsOnNonNullContractFailure()) {
                throw nonNullException;
            }
        }
        return result;
    }
}

