/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.bytedeco.javacv.BaseChildSettings;
import org.bytedeco.javacv.MarkedPlane;
import org.bytedeco.javacv.Marker;
import org.bytedeco.javacv.MarkerDetector;
import org.bytedeco.javacv.ProjectiveDevice;
import org.bytedeco.opencv.global.opencv_calib3d;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.CvMat;
import org.bytedeco.opencv.opencv_core.IplImage;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.MatVector;
import org.bytedeco.opencv.opencv_core.Point2f;
import org.bytedeco.opencv.opencv_core.Point2fVector;
import org.bytedeco.opencv.opencv_core.Point2fVectorVector;
import org.bytedeco.opencv.opencv_core.Point3f;
import org.bytedeco.opencv.opencv_core.Point3fVector;
import org.bytedeco.opencv.opencv_core.Point3fVectorVector;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.TermCriteria;

public class GeometricCalibrator {
    private Settings settings;
    MarkerDetector markerDetector;
    private MarkedPlane markedPlane;
    private ProjectiveDevice projectiveDevice;
    private LinkedList<Marker[]> allObjectMarkers = new LinkedList();
    private LinkedList<Marker[]> allImageMarkers = new LinkedList();
    private IplImage tempImage = null;
    private Marker[] lastDetectedMarkers = null;
    private CvMat warp = CvMat.create(3, 3);
    private CvMat prevWarp = CvMat.create(3, 3);
    private CvMat lastWarp = CvMat.create(3, 3);
    private CvMat warpSrcPts = CvMat.create(1, 4, 6, 2);
    private CvMat warpDstPts = CvMat.create(1, 4, 6, 2);
    private CvMat tempPts = CvMat.create(1, 4, 6, 2);

    public GeometricCalibrator(Settings settings, MarkerDetector.Settings detectorSettings, MarkedPlane markedPlane, ProjectiveDevice projectiveDevice) {
        this.settings = settings;
        this.markerDetector = new MarkerDetector(detectorSettings);
        this.markedPlane = markedPlane;
        this.projectiveDevice = projectiveDevice;
        opencv_core.cvSetIdentity(this.prevWarp);
        opencv_core.cvSetIdentity(this.lastWarp);
        if (markedPlane != null) {
            int w = markedPlane.getImage().width();
            int h = markedPlane.getImage().height();
            this.warpSrcPts.put(0.0, 0.0, w, 0.0, w, h, 0.0, h);
        }
    }

    public MarkerDetector getMarkerDetector() {
        return this.markerDetector;
    }

    public MarkedPlane getMarkedPlane() {
        return this.markedPlane;
    }

    public ProjectiveDevice getProjectiveDevice() {
        return this.projectiveDevice;
    }

    public LinkedList<Marker[]> getAllObjectMarkers() {
        return this.allObjectMarkers;
    }

    public void setAllObjectMarkers(LinkedList<Marker[]> allObjectMarkers) {
        this.allObjectMarkers = allObjectMarkers;
    }

    public LinkedList<Marker[]> getAllImageMarkers() {
        return this.allImageMarkers;
    }

    public void setAllImageMarkers(LinkedList<Marker[]> allImageMarkers) {
        this.allImageMarkers = allImageMarkers;
    }

    public Marker[] processImage(IplImage image) {
        boolean whiteMarkers;
        this.projectiveDevice.imageWidth = image.width();
        this.projectiveDevice.imageHeight = image.height();
        boolean bl = whiteMarkers = this.markedPlane.getForegroundColor().magnitude() > this.markedPlane.getBackgroundColor().magnitude();
        if (image.depth() > 8) {
            if (this.tempImage == null || this.tempImage.width() != image.width() || this.tempImage.height() != image.height()) {
                this.tempImage = IplImage.create(image.width(), image.height(), 8, 1, image.origin());
            }
            opencv_core.cvConvertScale(image, this.tempImage, 0.00390625, 0.0);
            this.lastDetectedMarkers = this.markerDetector.detect(this.tempImage, whiteMarkers);
        } else {
            this.lastDetectedMarkers = this.markerDetector.detect(image, whiteMarkers);
        }
        if ((double)this.lastDetectedMarkers.length < (double)this.markedPlane.getMarkers().length * this.settings.detectedBoardMin) {
            return null;
        }
        this.markedPlane.getTotalWarp(this.lastDetectedMarkers, this.warp);
        opencv_core.cvPerspectiveTransform(this.warpSrcPts, this.warpDstPts, this.warp);
        opencv_core.cvPerspectiveTransform(this.warpSrcPts, this.tempPts, this.prevWarp);
        double rmsePrev = opencv_core.cvNorm(this.warpDstPts, this.tempPts);
        opencv_core.cvPerspectiveTransform(this.warpSrcPts, this.tempPts, this.lastWarp);
        double rmseLast = opencv_core.cvNorm(this.warpDstPts, this.tempPts);
        opencv_core.cvCopy(this.warp, this.prevWarp);
        int imageSize = (image.width() + image.height()) / 2;
        if (rmsePrev < this.settings.patternSteadySize * (double)imageSize && rmseLast > this.settings.patternMovedSize * (double)imageSize) {
            return this.lastDetectedMarkers;
        }
        return null;
    }

    public void drawMarkers(IplImage image) {
        this.markerDetector.draw(image, this.lastDetectedMarkers);
    }

    public void addMarkers() {
        this.addMarkers(this.markedPlane.getMarkers(), this.lastDetectedMarkers);
    }

    public void addMarkers(Marker[] imageMarkers) {
        this.addMarkers(this.markedPlane.getMarkers(), imageMarkers);
    }

    public void addMarkers(Marker[] objectMarkers, Marker[] imageMarkers) {
        int maxLength = Math.min(objectMarkers.length, imageMarkers.length);
        Marker[] om = new Marker[maxLength];
        Marker[] im = new Marker[maxLength];
        int i = 0;
        block0: for (Marker m1 : objectMarkers) {
            for (Marker m2 : imageMarkers) {
                if (m1.id != m2.id) continue;
                om[i] = m1;
                im[i] = m2;
                ++i;
                continue block0;
            }
        }
        if (i < maxLength) {
            om = Arrays.copyOf(om, i);
            im = Arrays.copyOf(im, i);
        }
        this.allObjectMarkers.add(om);
        this.allImageMarkers.add(im);
        opencv_core.cvCopy(this.prevWarp, this.lastWarp);
    }

    public int getImageCount() {
        assert (this.allObjectMarkers.size() == this.allImageMarkers.size());
        return this.allObjectMarkers.size();
    }

    private Point3fVectorVector getObjectPoints(CvMat points, CvMat counts) {
        FloatBuffer pointsBuf = points.getFloatBuffer();
        IntBuffer countsBuf = counts.getIntBuffer();
        int n = counts.length();
        Point3fVectorVector vectors = new Point3fVectorVector(n);
        for (int i = 0; i < n; ++i) {
            int m = countsBuf.get();
            Point3fVector vector = new Point3fVector(m);
            for (int j = 0; j < m; ++j) {
                vector.put(j, new Point3f(pointsBuf.get(), pointsBuf.get(), pointsBuf.get()));
            }
            vectors.put(i, vector);
        }
        return vectors;
    }

    private Point2fVectorVector getImagePoints(CvMat points, CvMat counts) {
        FloatBuffer pointsBuf = points.getFloatBuffer();
        IntBuffer countsBuf = counts.getIntBuffer();
        int n = counts.length();
        Point2fVectorVector vectors = new Point2fVectorVector(n);
        for (int i = 0; i < n; ++i) {
            int m = countsBuf.get();
            Point2fVector vector = new Point2fVector(m);
            for (int j = 0; j < m; ++j) {
                vector.put(j, new Point2f(pointsBuf.get(), pointsBuf.get()));
            }
            vectors.put(i, vector);
        }
        return vectors;
    }

    private CvMat[] getPoints(boolean useCenters) {
        assert (this.allObjectMarkers.size() == this.allImageMarkers.size());
        Iterator i1 = this.allObjectMarkers.iterator();
        Iterator i2 = this.allImageMarkers.iterator();
        CvMat pointCounts = CvMat.create(1, this.allImageMarkers.size(), 4, 1);
        IntBuffer pointCountsBuf = pointCounts.getIntBuffer();
        int totalPointCount = 0;
        while (i1.hasNext() && i2.hasNext()) {
            Marker[] m1 = (Marker[])i1.next();
            Marker[] m2 = (Marker[])i2.next();
            assert (m1.length == m2.length);
            int n = m1.length * (useCenters ? 1 : 4);
            pointCountsBuf.put(n);
            totalPointCount += n;
        }
        i1 = this.allObjectMarkers.iterator();
        i2 = this.allImageMarkers.iterator();
        CvMat objectPoints = CvMat.create(1, totalPointCount, 5, 3);
        CvMat imagePoints = CvMat.create(1, totalPointCount, 5, 2);
        FloatBuffer objectPointsBuf = objectPoints.getFloatBuffer();
        FloatBuffer imagePointsBuf = imagePoints.getFloatBuffer();
        while (i1.hasNext() && i2.hasNext()) {
            Marker[] m1 = (Marker[])i1.next();
            Marker[] m2 = (Marker[])i2.next();
            for (int j = 0; j < m1.length; ++j) {
                if (useCenters) {
                    double[] c1 = m1[j].getCenter();
                    objectPointsBuf.put((float)c1[0]);
                    objectPointsBuf.put((float)c1[1]);
                    objectPointsBuf.put(0.0f);
                    double[] c2 = m2[j].getCenter();
                    imagePointsBuf.put((float)c2[0]);
                    imagePointsBuf.put((float)c2[1]);
                    continue;
                }
                for (int k = 0; k < 4; ++k) {
                    objectPointsBuf.put((float)m1[j].corners[2 * k]);
                    objectPointsBuf.put((float)m1[j].corners[2 * k + 1]);
                    objectPointsBuf.put(0.0f);
                    imagePointsBuf.put((float)m2[j].corners[2 * k]);
                    imagePointsBuf.put((float)m2[j].corners[2 * k + 1]);
                }
            }
        }
        return new CvMat[]{objectPoints, imagePoints, pointCounts};
    }

    public static double[] computeReprojectionError(CvMat object_points, CvMat image_points, CvMat point_counts, CvMat camera_matrix, CvMat dist_coeffs, CvMat rot_vects, CvMat trans_vects, CvMat per_view_errors) {
        CvMat image_points2 = CvMat.create(image_points.rows(), image_points.cols(), image_points.type());
        int image_count = rot_vects.rows();
        int points_so_far = 0;
        double total_err = 0.0;
        double max_err = 0.0;
        CvMat object_points_i = new CvMat();
        CvMat image_points_i = new CvMat();
        CvMat image_points2_i = new CvMat();
        IntBuffer point_counts_buf = point_counts.getIntBuffer();
        CvMat rot_vect = new CvMat();
        CvMat trans_vect = new CvMat();
        for (int i = 0; i < image_count; ++i) {
            object_points_i.reset();
            image_points_i.reset();
            image_points2_i.reset();
            int point_count = point_counts_buf.get(i);
            opencv_core.cvGetCols(object_points, object_points_i, points_so_far, points_so_far + point_count);
            opencv_core.cvGetCols(image_points, image_points_i, points_so_far, points_so_far + point_count);
            opencv_core.cvGetCols(image_points2, image_points2_i, points_so_far, points_so_far + point_count);
            points_so_far += point_count;
            opencv_core.cvGetRows(rot_vects, rot_vect, i, i + 1, 1);
            opencv_core.cvGetRows(trans_vects, trans_vect, i, i + 1, 1);
            opencv_calib3d.projectPoints(opencv_core.cvarrToMat(object_points_i), opencv_core.cvarrToMat(rot_vect), opencv_core.cvarrToMat(trans_vect), opencv_core.cvarrToMat(camera_matrix), opencv_core.cvarrToMat(dist_coeffs), opencv_core.cvarrToMat(image_points2_i));
            double err = opencv_core.cvNorm(image_points_i, image_points2_i);
            err *= err;
            if (per_view_errors != null) {
                per_view_errors.put(i, Math.sqrt(err / (double)point_count));
            }
            total_err += err;
            for (int j = 0; j < point_count; ++j) {
                double y2;
                double dy;
                double x1 = image_points_i.get(0, j, 0);
                double y1 = image_points_i.get(0, j, 1);
                double x2 = image_points2_i.get(0, j, 0);
                double dx = x1 - x2;
                err = Math.sqrt(dx * dx + (dy = y1 - (y2 = image_points2_i.get(0, j, 1))) * dy);
                if (!(err > max_err)) continue;
                max_err = err;
            }
        }
        return new double[]{Math.sqrt(total_err / (double)points_so_far), max_err};
    }

    public double[] calibrate(boolean useCenters) {
        int kn;
        ProjectiveDevice d = this.projectiveDevice;
        ProjectiveDevice.CalibrationSettings dsettings = (ProjectiveDevice.CalibrationSettings)d.getSettings();
        if (d.cameraMatrix == null) {
            d.cameraMatrix = CvMat.create(3, 3);
            opencv_core.cvSetZero(d.cameraMatrix);
            if ((dsettings.flags & 2) != 0) {
                d.cameraMatrix.put(0, dsettings.initAspectRatio);
                d.cameraMatrix.put(4, 1.0);
            }
        }
        int n = kn = dsettings.isFixK3() ? 4 : 5;
        if (dsettings.isRationalModel() && !dsettings.isFixK4() && !dsettings.isFixK4() && !dsettings.isFixK5()) {
            kn = 8;
        }
        if (d.distortionCoeffs == null || d.distortionCoeffs.cols() != kn) {
            d.distortionCoeffs = CvMat.create(1, kn);
            opencv_core.cvSetZero(d.distortionCoeffs);
        }
        CvMat rotVects = new CvMat();
        CvMat transVects = new CvMat();
        d.extrParams = CvMat.create(this.allImageMarkers.size(), 6);
        opencv_core.cvGetCols(d.extrParams, rotVects, 0, 3);
        opencv_core.cvGetCols(d.extrParams, transVects, 3, 6);
        CvMat[] points = this.getPoints(useCenters);
        MatVector rvecs = new MatVector();
        MatVector tvecs = new MatVector();
        Mat distortionCoeffs = new Mat();
        opencv_calib3d.calibrateCamera(this.getObjectPoints(points[0], points[2]), this.getImagePoints(points[1], points[2]), new Size(d.imageWidth, d.imageHeight), opencv_core.cvarrToMat(d.cameraMatrix), distortionCoeffs, rvecs, tvecs, dsettings.flags, new TermCriteria(3, 30, 2.220446049250313E-16));
        int n2 = (int)rvecs.size();
        CvMat row = new CvMat();
        for (int i = 0; i < n2; ++i) {
            opencv_core.cvTranspose(opencv_core.cvMat(rvecs.get(i)), opencv_core.cvGetRow(rotVects, row, i));
            opencv_core.cvTranspose(opencv_core.cvMat(tvecs.get(i)), opencv_core.cvGetRow(transVects, row, i));
        }
        d.distortionCoeffs = opencv_core.cvMat(distortionCoeffs).clone();
        if (opencv_core.cvCheckArr(d.cameraMatrix, 2, 0.0, 0.0) != 0 && opencv_core.cvCheckArr(d.distortionCoeffs, 2, 0.0, 0.0) != 0 && opencv_core.cvCheckArr(d.extrParams, 2, 0.0, 0.0) != 0) {
            d.reprojErrs = CvMat.create(1, this.allImageMarkers.size());
            double[] err = GeometricCalibrator.computeReprojectionError(points[0], points[1], points[2], d.cameraMatrix, d.distortionCoeffs, rotVects, transVects, d.reprojErrs);
            d.avgReprojErr = err[0];
            d.maxReprojErr = err[1];
            return err;
        }
        d.cameraMatrix = null;
        d.avgReprojErr = -1.0;
        d.maxReprojErr = -1.0;
        return null;
    }

    public static double[] computeStereoError(CvMat imagePoints1, CvMat imagePoints2, CvMat M1, CvMat D1, CvMat M2, CvMat D2, CvMat F) {
        int N = imagePoints1.cols();
        CvMat L1 = CvMat.create(1, N, 5, 3);
        CvMat L2 = CvMat.create(1, N, 5, 3);
        opencv_calib3d.undistortPoints(opencv_core.cvarrToMat(imagePoints1), opencv_core.cvarrToMat(imagePoints1), opencv_core.cvarrToMat(M1), opencv_core.cvarrToMat(D1), null, opencv_core.cvarrToMat(M1));
        opencv_calib3d.undistortPoints(opencv_core.cvarrToMat(imagePoints2), opencv_core.cvarrToMat(imagePoints2), opencv_core.cvarrToMat(M2), opencv_core.cvarrToMat(D2), null, opencv_core.cvarrToMat(M2));
        opencv_calib3d.computeCorrespondEpilines(opencv_core.cvarrToMat(imagePoints1), 1, opencv_core.cvarrToMat(F), opencv_core.cvarrToMat(L1));
        opencv_calib3d.computeCorrespondEpilines(opencv_core.cvarrToMat(imagePoints2), 2, opencv_core.cvarrToMat(F), opencv_core.cvarrToMat(L2));
        double avgErr = 0.0;
        double maxErr = 0.0;
        CvMat p1 = imagePoints1;
        CvMat p2 = imagePoints2;
        for (int i = 0; i < N; ++i) {
            double e1 = p1.get(0, i, 0) * L2.get(0, i, 0) + p1.get(0, i, 1) * L2.get(0, i, 1) + L2.get(0, i, 2);
            double e2 = p2.get(0, i, 0) * L1.get(0, i, 0) + p2.get(0, i, 1) * L1.get(0, i, 1) + L1.get(0, i, 2);
            double err = e1 * e1 + e2 * e2;
            avgErr += err;
            if (!((err = Math.sqrt(err)) > maxErr)) continue;
            maxErr = err;
        }
        return new double[]{Math.sqrt(avgErr / (double)N), maxErr};
    }

    public double[] calibrateStereo(boolean useCenters, GeometricCalibrator peer) {
        ProjectiveDevice d = this.projectiveDevice;
        ProjectiveDevice dp = peer.projectiveDevice;
        ProjectiveDevice.CalibrationSettings dsettings = (ProjectiveDevice.CalibrationSettings)d.getSettings();
        ProjectiveDevice.CalibrationSettings dpsettings = (ProjectiveDevice.CalibrationSettings)dp.getSettings();
        CvMat[] points1 = this.getPoints(useCenters);
        CvMat[] points2 = peer.getPoints(useCenters);
        FloatBuffer objPts1 = points1[0].getFloatBuffer();
        FloatBuffer imgPts1 = points1[1].getFloatBuffer();
        IntBuffer imgCount1 = points1[2].getIntBuffer();
        FloatBuffer objPts2 = points2[0].getFloatBuffer();
        FloatBuffer imgPts2 = points2[1].getFloatBuffer();
        IntBuffer imgCount2 = points2[2].getIntBuffer();
        assert (imgCount1.capacity() == imgCount2.capacity());
        CvMat objectPointsMat = CvMat.create(1, Math.min(objPts1.capacity(), objPts2.capacity()), 5, 3);
        CvMat imagePoints1Mat = CvMat.create(1, Math.min(imgPts1.capacity(), imgPts2.capacity()), 5, 2);
        CvMat imagePoints2Mat = CvMat.create(1, Math.min(imgPts1.capacity(), imgPts2.capacity()), 5, 2);
        CvMat pointCountsMat = CvMat.create(1, imgCount1.capacity(), 4, 1);
        FloatBuffer objectPoints = objectPointsMat.getFloatBuffer();
        FloatBuffer imagePoints1 = imagePoints1Mat.getFloatBuffer();
        FloatBuffer imagePoints2 = imagePoints2Mat.getFloatBuffer();
        IntBuffer pointCounts = pointCountsMat.getIntBuffer();
        int end1 = 0;
        int end2 = 0;
        for (int i = 0; i < imgCount1.capacity(); ++i) {
            int start1 = end1;
            int start2 = end2;
            end1 = start1 + imgCount1.get(i);
            end2 = start2 + imgCount2.get(i);
            int count = 0;
            block1: for (int j = start1; j < end1; ++j) {
                float x1 = objPts1.get(j * 3);
                float y1 = objPts1.get(j * 3 + 1);
                float z1 = objPts1.get(j * 3 + 2);
                for (int k = start2; k < end2; ++k) {
                    float x2 = objPts2.get(k * 3);
                    float y2 = objPts2.get(k * 3 + 1);
                    float z2 = objPts2.get(k * 3 + 2);
                    if (x1 != x2 || y1 != y2 || z1 != z2) continue;
                    objectPoints.put(x1);
                    objectPoints.put(y1);
                    objectPoints.put(z1);
                    imagePoints1.put(imgPts1.get(j * 2));
                    imagePoints1.put(imgPts1.get(j * 2 + 1));
                    imagePoints2.put(imgPts2.get(k * 2));
                    imagePoints2.put(imgPts2.get(k * 2 + 1));
                    ++count;
                    continue block1;
                }
            }
            if (count <= 0) continue;
            pointCounts.put(count);
        }
        objectPointsMat.cols(objectPoints.position() / 3);
        imagePoints1Mat.cols(imagePoints1.position() / 2);
        imagePoints2Mat.cols(imagePoints2.position() / 2);
        pointCountsMat.cols(pointCounts.position());
        d.R = CvMat.create(3, 3);
        d.R.put(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        d.T = CvMat.create(3, 1);
        d.T.put(0.0, 0.0, 0.0);
        d.E = CvMat.create(3, 3);
        opencv_core.cvSetZero(d.E);
        d.F = CvMat.create(3, 3);
        opencv_core.cvSetZero(d.F);
        dp.R = CvMat.create(3, 3);
        dp.T = CvMat.create(3, 1);
        dp.E = CvMat.create(3, 3);
        dp.F = CvMat.create(3, 3);
        opencv_calib3d.stereoCalibrate(this.getObjectPoints(objectPointsMat, pointCountsMat), this.getImagePoints(imagePoints1Mat, pointCountsMat), this.getImagePoints(imagePoints2Mat, pointCountsMat), opencv_core.cvarrToMat(d.cameraMatrix), opencv_core.cvarrToMat(d.distortionCoeffs), opencv_core.cvarrToMat(dp.cameraMatrix), opencv_core.cvarrToMat(dp.distortionCoeffs), new Size(d.imageWidth, d.imageHeight), opencv_core.cvarrToMat(dp.R), opencv_core.cvarrToMat(dp.T), opencv_core.cvarrToMat(dp.E), opencv_core.cvarrToMat(dp.F), dpsettings.flags, new TermCriteria(3, 100, 1.0E-6));
        d.avgEpipolarErr = 0.0;
        d.maxEpipolarErr = 0.0;
        double[] err = GeometricCalibrator.computeStereoError(imagePoints1Mat, imagePoints2Mat, d.cameraMatrix, d.distortionCoeffs, dp.cameraMatrix, dp.distortionCoeffs, dp.F);
        dp.avgEpipolarErr = err[0];
        dp.maxEpipolarErr = err[1];
        return err;
    }

    public static class Settings
    extends BaseChildSettings {
        double detectedBoardMin = 0.5;
        double patternSteadySize = 0.005;
        double patternMovedSize = 0.05;

        public double getDetectedBoardMin() {
            return this.detectedBoardMin;
        }

        public void setDetectedBoardMin(double detectedBoardMin) {
            this.detectedBoardMin = detectedBoardMin;
        }

        public double getPatternSteadySize() {
            return this.patternSteadySize;
        }

        public void setPatternSteadySize(double patternSteadySize) {
            this.patternSteadySize = patternSteadySize;
        }

        public double getPatternMovedSize() {
            return this.patternMovedSize;
        }

        public void setPatternMovedSize(double patternMovedSize) {
            this.patternMovedSize = patternMovedSize;
        }
    }
}

