/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.selector;

import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.Set;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.SemanticVersionComparator;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.data.SlotId;
import org.openqa.selenium.grid.data.SlotMatcher;
import org.openqa.selenium.grid.distributor.selector.SlotSelector;

public class GreedySlotSelector
implements SlotSelector {
    public static SlotSelector create(Config config) {
        return new GreedySlotSelector();
    }

    @Override
    public Set<SlotId> selectSlot(Capabilities capabilities, Set<NodeStatus> nodes, SlotMatcher slotMatcher) {
        return nodes.stream().filter(node -> node.hasCapacity(capabilities, slotMatcher) && node.getAvailability() == Availability.UP).sorted(Comparator.comparingDouble(NodeStatus::getLoad).reversed().thenComparingLong(node -> node.getSlots().size()).thenComparingLong(NodeStatus::getLastSessionCreated).thenComparing(Comparator.comparing(NodeStatus::getBrowserVersion, new SemanticVersionComparator().reversed()))).flatMap(node -> node.getSlots().stream().filter(slot -> slot.getSession() == null).filter(slot -> slot.isSupporting(capabilities, slotMatcher)).map(Slot::getId)).collect(ImmutableSet.toImmutableSet());
    }
}

