/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.DirectivesUtil;
import graphql.Internal;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.FieldDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetcherFactory;
import graphql.schema.DataFetcherFactoryEnvironment;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphqlDirectivesContainerTypeBuilder;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.FpKit;
import graphql.util.Interning;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@PublicApi
public class GraphQLFieldDefinition
implements GraphQLNamedSchemaElement,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final GraphQLOutputType originalType;
    private final DataFetcherFactory dataFetcherFactory;
    private final String deprecationReason;
    private final ImmutableList<GraphQLArgument> arguments;
    private final DirectivesUtil.DirectivesHolder directivesHolder;
    private final FieldDefinition definition;
    private GraphQLOutputType replacedType;
    public static final String CHILD_ARGUMENTS = "arguments";
    public static final String CHILD_TYPE = "type";

    @Internal
    private GraphQLFieldDefinition(String name, String description, GraphQLOutputType type, DataFetcherFactory dataFetcherFactory, List<GraphQLArgument> arguments, String deprecationReason, List<GraphQLDirective> directives, List<GraphQLAppliedDirective> appliedDirectives, FieldDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(type, () -> "type can't be null");
        Assert.assertNotNull(arguments, () -> "arguments can't be null");
        this.name = Interning.intern(name);
        this.description = description;
        this.originalType = type;
        this.dataFetcherFactory = dataFetcherFactory;
        this.arguments = ImmutableList.copyOf(arguments);
        this.directivesHolder = DirectivesUtil.DirectivesHolder.create(directives, appliedDirectives);
        this.deprecationReason = deprecationReason;
        this.definition = definition;
    }

    void replaceType(GraphQLOutputType type) {
        this.replacedType = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public GraphQLOutputType getType() {
        return this.replacedType != null ? this.replacedType : this.originalType;
    }

    @Internal
    @Deprecated(since="2018-12-03")
    DataFetcher<?> getDataFetcher() {
        if (this.dataFetcherFactory == null) {
            return null;
        }
        return this.dataFetcherFactory.get(DataFetcherFactoryEnvironment.newDataFetchingFactoryEnvironment().fieldDefinition(this).build());
    }

    public GraphQLArgument getArgument(String name) {
        for (GraphQLArgument argument : this.arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return this.directivesHolder.getDirectives();
    }

    @Override
    public Map<String, GraphQLDirective> getDirectivesByName() {
        return this.directivesHolder.getDirectivesByName();
    }

    @Override
    public Map<String, List<GraphQLDirective>> getAllDirectivesByName() {
        return this.directivesHolder.getAllDirectivesByName();
    }

    @Override
    public GraphQLDirective getDirective(String directiveName) {
        return this.directivesHolder.getDirective(directiveName);
    }

    @Override
    public List<GraphQLAppliedDirective> getAppliedDirectives() {
        return this.directivesHolder.getAppliedDirectives();
    }

    @Override
    public Map<String, List<GraphQLAppliedDirective>> getAllAppliedDirectivesByName() {
        return this.directivesHolder.getAllAppliedDirectivesByName();
    }

    @Override
    public GraphQLAppliedDirective getAppliedDirective(String directiveName) {
        return this.directivesHolder.getAppliedDirective(directiveName);
    }

    public List<GraphQLArgument> getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public FieldDefinition getDefinition() {
        return this.definition;
    }

    public String getDeprecationReason() {
        return this.deprecationReason;
    }

    public boolean isDeprecated() {
        return this.deprecationReason != null;
    }

    public String toString() {
        return "GraphQLFieldDefinition{name='" + this.name + "', type=" + String.valueOf(this.getType()) + ", arguments=" + String.valueOf(this.arguments) + ", dataFetcherFactory=" + String.valueOf(this.dataFetcherFactory) + ", description='" + this.description + "', deprecationReason='" + this.deprecationReason + "', definition=" + String.valueOf(this.definition) + "}";
    }

    public GraphQLFieldDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLFieldDefinition.newFieldDefinition(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public GraphQLSchemaElement copy() {
        return GraphQLFieldDefinition.newFieldDefinition(this).build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLFieldDefinition(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        ArrayList<GraphQLSchemaElement> children = new ArrayList<GraphQLSchemaElement>();
        children.add(this.getType());
        children.addAll(this.arguments);
        children.addAll(this.directivesHolder.getDirectives());
        children.addAll(this.directivesHolder.getAppliedDirectives());
        return children;
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().child(CHILD_TYPE, this.originalType).children(CHILD_ARGUMENTS, this.arguments).children("directives", this.directivesHolder.getDirectives()).children("appliedDirectives", this.directivesHolder.getAppliedDirectives()).build();
    }

    @Override
    public GraphQLSchemaElement withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> builder.replaceArguments(newChildren.getChildren(CHILD_ARGUMENTS)).type((GraphQLOutputType)newChildren.getChildOrNull(CHILD_TYPE)).replaceDirectives(newChildren.getChildren("directives")).replaceAppliedDirectives(newChildren.getChildren("appliedDirectives")));
    }

    @Override
    public final boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    public static Builder newFieldDefinition(GraphQLFieldDefinition existing) {
        return new Builder(existing);
    }

    public static Builder newFieldDefinition() {
        return new Builder();
    }

    @PublicApi
    public static class Builder
    extends GraphqlDirectivesContainerTypeBuilder<Builder, Builder> {
        private GraphQLOutputType type;
        private DataFetcherFactory<?> dataFetcherFactory;
        private String deprecationReason;
        private FieldDefinition definition;
        private final Map<String, GraphQLArgument> arguments = new LinkedHashMap<String, GraphQLArgument>();

        public Builder() {
        }

        public Builder(GraphQLFieldDefinition existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.type = existing.originalType;
            this.dataFetcherFactory = DataFetcherFactories.useDataFetcher(existing.getDataFetcher());
            this.deprecationReason = existing.getDeprecationReason();
            this.definition = existing.getDefinition();
            this.arguments.putAll(FpKit.getByName(existing.getArguments(), GraphQLArgument::getName));
            this.copyExistingDirectives(existing);
        }

        public Builder definition(FieldDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder type(GraphQLObjectType.Builder builder) {
            return this.type(builder.build());
        }

        public Builder type(GraphQLInterfaceType.Builder builder) {
            return this.type(builder.build());
        }

        public Builder type(GraphQLUnionType.Builder builder) {
            return this.type(builder.build());
        }

        public Builder type(GraphQLOutputType type) {
            this.type = type;
            return this;
        }

        @Deprecated(since="2018-12-03")
        public Builder dataFetcher(DataFetcher<?> dataFetcher) {
            Assert.assertNotNull(dataFetcher, () -> "dataFetcher must be not null");
            this.dataFetcherFactory = DataFetcherFactories.useDataFetcher(dataFetcher);
            return this;
        }

        @Deprecated(since="2018-12-03")
        public Builder dataFetcherFactory(DataFetcherFactory<?> dataFetcherFactory) {
            Assert.assertNotNull(dataFetcherFactory, () -> "dataFetcherFactory must be not null");
            this.dataFetcherFactory = dataFetcherFactory;
            return this;
        }

        @Deprecated(since="2018-12-03")
        public Builder staticValue(Object value) {
            this.dataFetcherFactory = DataFetcherFactories.useDataFetcher(environment -> value);
            return this;
        }

        public Builder argument(GraphQLArgument argument) {
            Assert.assertNotNull(argument, () -> "argument can't be null");
            this.arguments.put(argument.getName(), argument);
            return this;
        }

        public Builder argument(UnaryOperator<GraphQLArgument.Builder> builderFunction) {
            GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
            builder = (GraphQLArgument.Builder)builderFunction.apply(builder);
            return this.argument(builder);
        }

        public Builder argument(GraphQLArgument.Builder builder) {
            this.argument(builder.build());
            return this;
        }

        @Deprecated(since="2019-02-06")
        public Builder argument(List<GraphQLArgument> arguments) {
            return this.arguments(arguments);
        }

        public Builder arguments(List<GraphQLArgument> arguments) {
            Assert.assertNotNull(arguments, () -> "arguments can't be null");
            for (GraphQLArgument argument : arguments) {
                this.argument(argument);
            }
            return this;
        }

        public Builder replaceArguments(List<GraphQLArgument> arguments) {
            Assert.assertNotNull(arguments, () -> "arguments can't be null");
            this.arguments.clear();
            for (GraphQLArgument argument : arguments) {
                this.argument(argument);
            }
            return this;
        }

        public Builder clearArguments() {
            this.arguments.clear();
            return this;
        }

        public Builder deprecate(String deprecationReason) {
            this.deprecationReason = deprecationReason;
            return this;
        }

        @Override
        public Builder replaceDirectives(List<GraphQLDirective> directives) {
            return (Builder)super.replaceDirectives(directives);
        }

        @Override
        public Builder withDirectives(GraphQLDirective ... directives) {
            return (Builder)super.withDirectives(directives);
        }

        @Override
        public Builder withDirective(GraphQLDirective directive) {
            return (Builder)super.withDirective(directive);
        }

        @Override
        public Builder withDirective(GraphQLDirective.Builder builder) {
            return (Builder)super.withDirective(builder);
        }

        @Override
        public Builder clearDirectives() {
            return (Builder)super.clearDirectives();
        }

        @Override
        public Builder name(String name) {
            return (Builder)super.name(name);
        }

        @Override
        public Builder description(String description) {
            return (Builder)super.description(description);
        }

        public GraphQLFieldDefinition build() {
            return new GraphQLFieldDefinition(this.name, this.description, this.type, this.dataFetcherFactory, this.sort(this.arguments, GraphQLFieldDefinition.class, GraphQLArgument.class), this.deprecationReason, this.sort(this.directives, GraphQLFieldDefinition.class, GraphQLDirective.class), this.sort(this.appliedDirectives, GraphQLScalarType.class, GraphQLAppliedDirective.class), this.definition);
        }
    }
}

