package org.openqa.selenium.devtools.v141.runtime.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Issued when object should be inspected (for example, as a result of inspect() command line API
 * call).
 */
public class InspectRequested {

    private final org.openqa.selenium.devtools.v141.runtime.model.RemoteObject object;

    private final java.util.Map<String, Object> hints;

    private final java.util.Optional<org.openqa.selenium.devtools.v141.runtime.model.ExecutionContextId> executionContextId;

    public InspectRequested(org.openqa.selenium.devtools.v141.runtime.model.RemoteObject object, java.util.Map<String, Object> hints, java.util.Optional<org.openqa.selenium.devtools.v141.runtime.model.ExecutionContextId> executionContextId) {
        this.object = java.util.Objects.requireNonNull(object, "object is required");
        this.hints = java.util.Objects.requireNonNull(hints, "hints is required");
        this.executionContextId = executionContextId;
    }

    public org.openqa.selenium.devtools.v141.runtime.model.RemoteObject getObject() {
        return object;
    }

    public java.util.Map<String, Object> getHints() {
        return hints;
    }

    /**
     * Identifier of the context where the call was made.
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v141.runtime.model.ExecutionContextId> getExecutionContextId() {
        return executionContextId;
    }

    private static InspectRequested fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v141.runtime.model.RemoteObject object = null;
        java.util.Map<String, Object> hints = null;
        java.util.Optional<org.openqa.selenium.devtools.v141.runtime.model.ExecutionContextId> executionContextId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "object":
                    object = input.read(org.openqa.selenium.devtools.v141.runtime.model.RemoteObject.class);
                    break;
                case "hints":
                    hints = (java.util.Map<String, Object>) input.read(java.util.Map.class);
                    break;
                case "executionContextId":
                    executionContextId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v141.runtime.model.ExecutionContextId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new InspectRequested(object, hints, executionContextId);
    }
}
