/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.IOIndexedException;
import org.apache.commons.io.output.BrokenWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.io.output.TeeWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TeeWriterTest {
    TeeWriterTest() {
    }

    @Test
    void testArrayIOExceptionOnAppendChar1() {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        int data = 65;
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> tw.append('A'));
        ((StringWriter)Mockito.verify((Object)goodW)).append('A');
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnAppendChar2() {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        int data = 65;
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> tw.append('A'));
        ((StringWriter)Mockito.verify((Object)goodW)).append('A');
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnAppendCharSequence1() {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        String data = "A";
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> tw.append((CharSequence)"A"));
        ((StringWriter)Mockito.verify((Object)goodW)).append("A");
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnAppendCharSequence2() {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        String data = "A";
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> tw.append((CharSequence)"A"));
        ((StringWriter)Mockito.verify((Object)goodW)).append("A");
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnAppendCharSequenceIntInt1() {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        String data = "A";
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> tw.append((CharSequence)"A", 0, 0));
        ((StringWriter)Mockito.verify((Object)goodW)).append("A", 0, 0);
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnAppendCharSequenceIntInt2() {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        String data = "A";
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> tw.append((CharSequence)"A", 0, 0));
        ((StringWriter)Mockito.verify((Object)goodW)).append("A", 0, 0);
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnClose1() throws IOException {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> ((TeeWriter)tw).close());
        ((StringWriter)Mockito.verify((Object)goodW)).close();
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnClose2() throws IOException {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> ((TeeWriter)tw).close());
        ((StringWriter)Mockito.verify((Object)goodW)).close();
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnFlush1() {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> ((TeeWriter)tw).flush());
        ((StringWriter)Mockito.verify((Object)goodW)).flush();
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnFlush2() {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> ((TeeWriter)tw).flush());
        ((StringWriter)Mockito.verify((Object)goodW)).flush();
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnWriteCharArray1() throws IOException {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        char[] data = new char[]{'a'};
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> tw.write(data));
        ((StringWriter)Mockito.verify((Object)goodW)).write(data);
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnWriteCharArray2() throws IOException {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        char[] data = new char[]{'a'};
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> tw.write(data));
        ((StringWriter)Mockito.verify((Object)goodW)).write(data);
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnWriteCharArrayIntInt1() {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        char[] data = new char[]{'a'};
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> tw.write(data, 0, 0));
        ((StringWriter)Mockito.verify((Object)goodW)).write(data, 0, 0);
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnWriteCharArrayIntInt2() {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        char[] data = new char[]{'a'};
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> tw.write(data, 0, 0));
        ((StringWriter)Mockito.verify((Object)goodW)).write(data, 0, 0);
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnWriteInt1() {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        int data = 32;
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> tw.write(32));
        ((StringWriter)Mockito.verify((Object)goodW)).write(32);
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnWriteInt2() {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> tw.write(32));
        ((StringWriter)Mockito.verify((Object)goodW)).write(32);
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnWriteString1() {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        String data = "A";
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> tw.write("A"));
        ((StringWriter)Mockito.verify((Object)goodW)).write("A");
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnWriteString2() {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        String data = "A";
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> tw.write("A"));
        ((StringWriter)Mockito.verify((Object)goodW)).write("A");
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnWriteStringIntInt1() {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{badW, goodW, null});
        String data = "A";
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> tw.write("A", 0, 0));
        ((StringWriter)Mockito.verify((Object)goodW)).write("A", 0, 0);
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)0, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testArrayIOExceptionOnWriteStringIntInt2() {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(new Writer[]{goodW, badW, null});
        String data = "A";
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> tw.write("A", 0, 0));
        ((StringWriter)Mockito.verify((Object)goodW)).write("A", 0, 0);
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testCollectionCloseBranchIOException() throws IOException {
        BrokenWriter badW = BrokenWriter.INSTANCE;
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeWriter tw = new TeeWriter(Arrays.asList(goodW, badW, null));
        IOExceptionList e = (IOExceptionList)Assertions.assertThrows(IOExceptionList.class, () -> ((TeeWriter)tw).close());
        ((StringWriter)Mockito.verify((Object)goodW)).close();
        Assertions.assertEquals((int)1, (int)e.getCauseList().size());
        Assertions.assertEquals((int)1, (int)((IOIndexedException)e.getCause(0, IOIndexedException.class)).getIndex());
    }

    @Test
    void testConstructorsNull() throws IOException {
        try (TeeWriter teeWriter = new TeeWriter((Writer[])null);){
            teeWriter.append('a');
            teeWriter.flush();
        }
        teeWriter = new TeeWriter((Collection)null);
        try {
            teeWriter.append('a');
            teeWriter.flush();
        }
        finally {
            teeWriter.close();
        }
        Assertions.assertTrue((boolean)true, (String)"Dummy to show test completed OK");
    }

    @Test
    void testTee() throws IOException {
        StringBuilderWriter sbw1 = new StringBuilderWriter();
        StringBuilderWriter sbw2 = new StringBuilderWriter();
        StringBuilderWriter expected = new StringBuilderWriter();
        try (TeeWriter tw = new TeeWriter(new Writer[]{sbw1, sbw2, null});){
            int i;
            for (int i2 = 0; i2 < 20; ++i2) {
                tw.write(i2);
                expected.write(i2);
            }
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw1.toString(), (String)"TeeWriter.write(int)");
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw2.toString(), (String)"TeeWriter.write(int)");
            char[] array = new char[10];
            for (i = 20; i < 30; ++i) {
                array[i - 20] = (char)i;
            }
            tw.write(array);
            expected.write(array);
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw1.toString(), (String)"TeeWriter.write(char[])");
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw2.toString(), (String)"TeeWriter.write(char[])");
            for (i = 25; i < 35; ++i) {
                array[i - 25] = (char)i;
            }
            tw.write(array, 5, 5);
            expected.write(array, 5, 5);
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw1.toString(), (String)"TeeOutputStream.write(byte[], int, int)");
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw2.toString(), (String)"TeeOutputStream.write(byte[], int, int)");
            for (i = 0; i < 20; ++i) {
                tw.append((char)i);
                expected.append((char)i);
            }
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw1.toString(), (String)"TeeWriter.append(char)");
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw2.toString(), (String)"TeeWriter.append(char)");
            for (i = 20; i < 30; ++i) {
                array[i - 20] = (char)i;
            }
            tw.append((CharSequence)new String(array));
            expected.append((CharSequence)new String(array));
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw1.toString(), (String)"TeeWriter.append(CharSequence)");
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw2.toString(), (String)"TeeWriter.append(CharSequence)");
            for (i = 25; i < 35; ++i) {
                array[i - 25] = (char)i;
            }
            tw.append((CharSequence)new String(array), 5, 5);
            expected.append((CharSequence)new String(array), 5, 5);
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw1.toString(), (String)"TeeWriter.append(CharSequence, int, int)");
            Assertions.assertEquals((Object)expected.toString(), (Object)sbw2.toString(), (String)"TeeWriter.append(CharSequence, int, int)");
            expected.flush();
            expected.close();
            tw.flush();
        }
    }
}

