/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.NodeDataTls;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<cv::instr::NodeDataTls*>"})
@Properties(inherit={opencv_core.class})
public class NodeDataTlsVector
extends Pointer {
    public NodeDataTlsVector(Pointer p) {
        super(p);
    }

    public NodeDataTlsVector(NodeDataTls value) {
        this(1L);
        this.put(0L, value);
    }

    public NodeDataTlsVector(NodeDataTls ... array) {
        this(array.length);
        this.put(array);
    }

    public NodeDataTlsVector() {
        this.allocate();
    }

    public NodeDataTlsVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native NodeDataTlsVector put(@ByRef NodeDataTlsVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public NodeDataTls front() {
        return this.get(0L);
    }

    public NodeDataTls back() {
        return this.get(this.size() - 1L);
    }

    @Index(function="at")
    public native NodeDataTls get(@Cast(value={"size_t"}) long var1);

    public native NodeDataTlsVector put(@Cast(value={"size_t"}) long var1, NodeDataTls var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, NodeDataTls var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public NodeDataTls[] get() {
        NodeDataTls[] array = new NodeDataTls[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.get());
    }

    public NodeDataTls pop_back() {
        long size = this.size();
        NodeDataTls value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public NodeDataTlsVector push_back(NodeDataTls value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public NodeDataTlsVector put(NodeDataTls value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public NodeDataTlsVector put(NodeDataTls ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator ++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator =="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator *"})
        @Const
        public native NodeDataTls get();
    }
}

