/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.PublicApi;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactory;
import graphql.schema.DataFetcherFactoryEnvironment;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;

@PublicApi
public class DataFetcherFactories {
    public static <T> DataFetcherFactory<T> useDataFetcher(final DataFetcher<T> dataFetcher) {
        return new DataFetcherFactory<T>(){

            @Override
            public DataFetcher<T> get(DataFetcherFactoryEnvironment environment) {
                return dataFetcher;
            }

            @Override
            public DataFetcher<T> get(GraphQLFieldDefinition fieldDefinition) {
                return dataFetcher;
            }
        };
    }

    public static DataFetcher<?> wrapDataFetcher(DataFetcher<?> delegateDataFetcher, BiFunction<DataFetchingEnvironment, Object, Object> mapFunction) {
        return environment -> {
            Object value = delegateDataFetcher.get(environment);
            if (value instanceof CompletionStage) {
                return ((CompletionStage)value).thenApply(v -> mapFunction.apply(environment, v));
            }
            return mapFunction.apply(environment, value);
        };
    }
}

