package org.openqa.selenium.devtools.v141.runtime.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * If `debuggerId` is set stack trace comes from another debugger and can be resolved there. This
 * allows to track cross-debugger calls. See `Runtime.StackTrace` and `Debugger.paused` for usages.
 */
@org.openqa.selenium.Beta()
public class StackTraceId {

    private final java.lang.String id;

    private final java.util.Optional<org.openqa.selenium.devtools.v141.runtime.model.UniqueDebuggerId> debuggerId;

    public StackTraceId(java.lang.String id, java.util.Optional<org.openqa.selenium.devtools.v141.runtime.model.UniqueDebuggerId> debuggerId) {
        this.id = java.util.Objects.requireNonNull(id, "id is required");
        this.debuggerId = debuggerId;
    }

    public java.lang.String getId() {
        return id;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v141.runtime.model.UniqueDebuggerId> getDebuggerId() {
        return debuggerId;
    }

    private static StackTraceId fromJson(JsonInput input) {
        java.lang.String id = null;
        java.util.Optional<org.openqa.selenium.devtools.v141.runtime.model.UniqueDebuggerId> debuggerId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "id":
                    id = input.nextString();
                    break;
                case "debuggerId":
                    debuggerId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v141.runtime.model.UniqueDebuggerId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new StackTraceId(id, debuggerId);
    }
}
