package org.openqa.selenium.devtools.v139.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum CookieExclusionReason {

    EXCLUDESAMESITEUNSPECIFIEDTREATEDASLAX("ExcludeSameSiteUnspecifiedTreatedAsLax"),
    EXCLUDESAMESITENONEINSECURE("ExcludeSameSiteNoneInsecure"),
    EXCLUDESAMESITELAX("ExcludeSameSiteLax"),
    EXCLUDESAMESITESTRICT("ExcludeSameSiteStrict"),
    EXCLUDEINVALIDSAMEPARTY("ExcludeInvalidSameParty"),
    EXCLUDESAMEPARTYCROSSPARTYCONTEXT("ExcludeSamePartyCrossPartyContext"),
    EXCLUDEDOMAINNONASCII("ExcludeDomainNonASCII"),
    EXCLUDETHIRDPARTYCOOKIEBLOCKEDINFIRSTPARTYSET("ExcludeThirdPartyCookieBlockedInFirstPartySet"),
    EXCLUDETHIRDPARTYPHASEOUT("ExcludeThirdPartyPhaseout"),
    EXCLUDEPORTMISMATCH("ExcludePortMismatch"),
    EXCLUDESCHEMEMISMATCH("ExcludeSchemeMismatch");

    private String value;

    CookieExclusionReason(String value) {
        this.value = value;
    }

    public static CookieExclusionReason fromString(String s) {
        return java.util.Arrays.stream(CookieExclusionReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within CookieExclusionReason "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static CookieExclusionReason fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
